/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.metadata;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.ts.ObjectType;

public class FlowMetadataUtils {
    private FlowMetadataUtils() {
    }

    private static Optional<DWMetadata> getMetadata(DWType weaveType, FlowMetadataKey metadataKey) {
        return MetadataUtils.getMetadata((DWType)weaveType, (String)metadataKey.getKey());
    }

    public static boolean isQueryBuilder(DWType weaveType) {
        return FlowMetadataUtils.getMetadata(weaveType, FlowMetadataKey.QUERY_BUILDER).isPresent() || FlowMetadataUtils.hasFilterAndFieldSelectorAnnotations(weaveType);
    }

    public static boolean isResultSetFilter(DWType weaveType) {
        return FlowMetadataUtils.getMetadata(weaveType, FlowMetadataKey.RESULT_SET_FILTER).isPresent();
    }

    public static boolean isFieldSelector(DWType weaveType) {
        return FlowMetadataUtils.getMetadata(weaveType, FlowMetadataKey.FIELD_SELECTOR).isPresent();
    }

    public static boolean isFieldOrder(DWType weaveType) {
        return FlowMetadataUtils.getMetadata(weaveType, FlowMetadataKey.FIELD_ORDER).isPresent();
    }

    public static boolean isFieldLimit(DWType weaveType) {
        return FlowMetadataUtils.getMetadata(weaveType, FlowMetadataKey.FIELD_LIMIT).isPresent();
    }

    static boolean hasFilterAndFieldSelectorAnnotations(DWType weaveType) {
        if ((weaveType = TypeUtils.resolveReferenceType((DWType)weaveType)) instanceof ObjectType) {
            ObjectType objectType = (ObjectType)weaveType;
            boolean hasFilter = false;
            boolean hasFieldSelector = false;
            if (objectType.getProperties() != null) {
                for (KeyValuePairType pair : objectType.getProperties()) {
                    if (FlowMetadataUtils.isFieldSelector(pair.getValue())) {
                        hasFieldSelector = true;
                        if (!hasFilter) continue;
                        return true;
                    }
                    if (!FlowMetadataUtils.isResultSetFilter(pair.getValue())) continue;
                    hasFilter = true;
                    if (!hasFieldSelector) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

