/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ImplicitAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2PasswordAuthenticationType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class AuthenticationTypeSerializerTest {
    Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private void assertSerializationAndDeserialization(AuthenticationType authenticationType) {
        String json = this.gson.toJson((Object)authenticationType);
        Map map = (Map)this.gson.fromJson(json, Map.class);
        AuthenticationType actualAuthType = AuthenticationTypeDeserializer.fromMap((Map)map);
        Assertions.assertEquals((Object)authenticationType, (Object)actualAuthType);
    }

    @Nested
    @DisplayName(value="OAuth2 Serialization and Deserialization")
    class OAuth2 {
        OAuth2() {
        }

        @Test
        @DisplayName(value="GIVEN OAuth2AuthCodeAuthenticationType WHEN serialize THEN return correct map")
        public void givenOAuth2AuthCodeAuthenticationTypeWhenSerializeThenReturnCorrectMap() {
            OAuth2AuthCodeAuthenticationType authType = new OAuth2AuthCodeAuthenticationType(OAuth2AuthenticationType.Placement.basicAuth, "refresh.url", List.of("scope1", "scope2"), "authorization.url", "token.url");
            AuthenticationTypeSerializerTest.this.assertSerializationAndDeserialization((AuthenticationType)authType);
        }

        @Test
        @DisplayName(value="GIVEN OAuth2ClientCredentialsAuthenticationType WHEN deserialize THEN return correct object")
        public void givenOAuth2ClientCredentialsAuthenticationTypeWhenDeserializeThenReturnCorrectObject() {
            OAuth2ClientCredentialsAuthenticationType authType = new OAuth2ClientCredentialsAuthenticationType(OAuth2AuthenticationType.Placement.basicAuth, "refresh.url", List.of("scope1", "scope2"), "token.url");
            AuthenticationTypeSerializerTest.this.assertSerializationAndDeserialization((AuthenticationType)authType);
        }

        @Test
        @DisplayName(value="GIVEN OAuth2ImplicitAuthenticationType WHEN deserialize THEN return correct object")
        public void givenOAuth2ImplicitAuthenticationTypeWhenDeserializeThenReturnCorrectObject() {
            OAuth2ImplicitAuthenticationType authType = new OAuth2ImplicitAuthenticationType(OAuth2AuthenticationType.Placement.basicAuth, "refresh.url", List.of("scope1", "scope2"), "authorization.url");
            AuthenticationTypeSerializerTest.this.assertSerializationAndDeserialization((AuthenticationType)authType);
        }

        @Test
        @DisplayName(value="GIVEN OAuth2PasswordAuthenticationType WHEN deserialize THEN return correct object")
        public void givenOAuth2PasswordAuthenticationTypeWhenDeserializeThenReturnCorrectObject() {
            OAuth2PasswordAuthenticationType authType = new OAuth2PasswordAuthenticationType(OAuth2AuthenticationType.Placement.basicAuth, "refresh.url", List.of("scope1", "scope2"), "token.url");
            AuthenticationTypeSerializerTest.this.assertSerializationAndDeserialization((AuthenticationType)authType);
        }
    }

    @Nested
    @DisplayName(value="NOT OAuth2 Serialization and Deserialization")
    class NotOAuth2 {
        NotOAuth2() {
        }

        @Test
        @DisplayName(value="GIVEN ApiKeyHttpAuthenticationType WHEN serialize THEN return correct map")
        public void givenApiKeyHttpAuthenticationTypeWhenSerializeThenReturnCorrectMap() {
            ApiKeyHttpAuthenticationType authType = new ApiKeyHttpAuthenticationType("subType", ApiKeyHttpAuthenticationType.In.query, "name");
            AuthenticationTypeSerializerTest.this.assertSerializationAndDeserialization((AuthenticationType)authType);
        }

        @Test
        @DisplayName(value="GIVEN HttpAuthenticationType WHEN serialize THEN return correct map")
        public void givenHttpAuthenticationTypeWhenSerializeThenReturnCorrectMap() {
            HttpAuthenticationType authType = new HttpAuthenticationType(HttpAuthenticationType.Type.basic, "subType");
            AuthenticationTypeSerializerTest.this.assertSerializationAndDeserialization((AuthenticationType)authType);
        }
    }
}

