%dw 2.8

import * from dw::core::Arrays

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::Trigger
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::decorator::ValueProvider
import * from com::mulesoft::connectivity::metadata::Builder
import * from com::mulesoft::connectivity::Types

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var connectionProvider = defineBasicHttpConnectionProvider<BasicAuthSchema & { baseUri: String }>(
    (connectionInfo) -> {username: connectionInfo.username, password: connectionInfo.password},
    (parameter) -> {baseUri: parameter.baseUri}
)

@ConnectionElement()
var oauth2AuthCodeConnectionProvider = defineOAuth2Connection<{baseUri: String, accessToken: String}>(
    (parameter) -> {accessToken: parameter.accessToken},
    (parameter) -> {baseUri: parameter.baseUri},
    {
        grantType: 'authorizationCode',
        authorizationUrl: "http://localhost/authorize",
        tokenUrl: "http://localhost/token",
        scopes: ["test"]
    }
)

@ConnectionElement()
var oAuthAuthorizationCodeExtensions = defineOAuth2Connection<{baseUri: String, accessToken: String}>(
    (parameter) -> {accessToken: parameter.accessToken},
    (parameter) -> {baseUri: parameter.baseUri},
    {
        grantType: 'authorizationCode',
        authorizationUrl: "http://localhost/authorize",
        tokenUrl: "http://localhost/token",
        scopes: ["test"]
    },
   (parameter) ->   [
                        {inDance: true, in: "header", name:"tenantid", value: parameter.accessToken}
                    ]
)

var getUserById : Operation<{userId: String}, HttpResponse<{id: String, name: String, email: String}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
  name: "getUserByIdEndpoint",
  displayName: "Get user by id",
  executor: (parameter, connection) ->
    success({
      contentType: "application/json",
      status: 200,
      headers: {},
      cookies: {},
      body: {
        id: "1",
        name: "Name",
        email: "name@email.com"
      }
  })
}
