/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.api.interpreter.FlowPlatformManagedConnection;
import com.mulesoft.connectivity.flow.internal.connector.FlowMetadataProvider;
import com.mulesoft.connectivity.flow.internal.connector.FlowOperation;
import com.mulesoft.connectivity.flow.internal.connector.FlowTrigger;
import com.mulesoft.connectivity.flow.internal.connector.FlowValueProvider;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.flow.internal.executables.Executables;
import com.mulesoft.connectivity.flow.internal.executables.Provider;
import com.mulesoft.connectivity.linkweave.api.connector.MetadataProvider;
import com.mulesoft.connectivity.linkweave.api.connector.Operation;
import com.mulesoft.connectivity.linkweave.api.connector.Trigger;
import com.mulesoft.connectivity.linkweave.api.connector.ValueProvider;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.Map;
import java.util.Optional;

class FlowConnection
implements com.mulesoft.connectivity.linkweave.api.connector.Connection {
    private final ModelInterpreter modelInterpreter;
    private final ConnectionDescription connectionDescription;
    private final Map<String, Object> connectionInfo;
    private final Executables executables;
    private final String connectionDeveloperName;
    private final boolean platformManagedConnection;

    FlowConnection(ModelInterpreter modelInterpreter, ConnectionDescription connectionDescription, Map<String, Object> connectionInfo, Executables executables, String connectionDeveloperName, boolean platformManagedConnection) {
        this.modelInterpreter = modelInterpreter;
        this.connectionDescription = connectionDescription;
        this.connectionInfo = connectionInfo;
        this.executables = executables;
        this.connectionDeveloperName = connectionDeveloperName;
        this.platformManagedConnection = platformManagedConnection;
    }

    public ConnectionValidationResult test() {
        TestConnectionModel testConnectionModel = this.connectionDescription.toConnectionProviderModel().getTestConnection();
        return this.modelInterpreter.testConnection(testConnectionModel, this.asHolder());
    }

    public Optional<Operation> getOperation(String name, Integer version) {
        return Optional.ofNullable(this.executables.getOperations().get(name).getVersions().get(version)).map(executableVersion -> new FlowOperation(name, this.modelInterpreter, (ExecutableVersion)executableVersion, this));
    }

    public Optional<Trigger> getTrigger(String name, Integer version) {
        return Optional.ofNullable(this.executables.getTriggers().get(name).getVersions().get(version)).map(executableVersion -> new FlowTrigger(this.modelInterpreter, name, (ExecutableVersion)executableVersion, this));
    }

    public Optional<ValueProvider> getValueProvider(String name) {
        return Optional.ofNullable(this.executables.getValueProviders().get(name)).map(valueProvider -> new FlowValueProvider(this.modelInterpreter, (Provider)valueProvider, this));
    }

    public Optional<MetadataProvider> getMetadataProvider(String name) {
        return Optional.ofNullable(this.executables.getTypeProviders().get(name)).map(typeProvider -> new FlowMetadataProvider(this.modelInterpreter, (Provider)typeProvider, this));
    }

    Connection<?> asHolder() {
        if (this.platformManagedConnection) {
            return FlowPlatformManagedConnection.of(Map.of("namedUrl", "callout:" + this.connectionDeveloperName));
        }
        return Connection.of((BaseConnectionProviderModel)this.connectionDescription.toConnectionProviderModel(), this.connectionInfo);
    }
}

