/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.8

import * from com::mulesoft::connectivity::flow::QueryBuilder

/**
* Annotates operations that should be understood as Query Builder Operations
*/
@AnnotationTarget(targets = ["KeyType", "Type", "TypeExpression"])
@Metadata(key = "flow.queryBuilder")
annotation QueryBuilder(value: {} = {})

/**
* Annotates a field to mark it to be used for projection fields
*/
@AnnotationTarget(targets = ["TypeExpression"])
@Metadata(key = "flow.fieldSelector")
annotation FieldSelector(value: {} = {})

/**
* Annotates a field to mark it to be used for query order
*/
@AnnotationTarget(targets = ["TypeExpression"])
@Metadata(key = "flow.fieldOrder")
annotation FieldOrder(value: {} = {})

/**
* Annotates a field to define the operators supported in the query builder
*/
@AnnotationTarget(targets = ["TypeExpression"])
@Metadata(key = "flow.resultSetFilter")
annotation ResultSetFilter(value: {} = {})


@AnnotationTarget(targets = ["TypeExpression"])
@Metadata(key = "flow.operators")
annotation OperatorsFilter(value: Array<String>)

/**
* Annotates a field to specify the limit on the number of records to return
*/
@AnnotationTarget(targets = ["TypeExpression"])
@Metadata(key = "flow.limit")
annotation FieldLimit(value: {} = {})
