/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.7

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::transport::Http

type FlowPlatformManagedConnectionInputType = {
    namedUrl: String
}

type HttpFlowPlatformManagedConnection<ConnectionType <: Connection, InputType <: FlowPlatformManagedConnectionInputType> = {
    connect: (InputType) -> HttpConnection
}

var defaultHttpFlowPlatformManagedConnectionProvider : HttpFlowPlatformManagedConnection = {
    connect: (cInput) -> (httpRequest: HttpRequester) -> doRequest(httpRequest update {
                                                                   case .baseUri! -> cInput.namedUrl
                                                                 })
}