/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.7

import * from com::mulesoft::connectivity::Model

fun mapQueryBuilderResult<InputType, ResultType, FailureResultType <: ResultFailure, ConnectionExecutorType, NewOpResultType, NewFailureResultType>
  (executor: Executor<InputType, ResultType, FailureResultType, ConnectionExecutorType>,
  successMapper: (ResultType, InputType) -> NewOpResultType,
  failureMapper: (FailureResultType) -> NewFailureResultType)
    : Executor<InputType, NewOpResultType, NewFailureResultType, ConnectionExecutorType> =
  (inputType: InputType, connectionExecutorType: ConnectionExecutorType) ->
                                                     executor(inputType, connectionExecutorType) match {
                                                         case is ResultSuccess<ResultType> -> $ update { case value at .value -> successMapper(value, inputType) }
                                                         case is FailureResultType -> failureMapper($)
                                                     }