/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.7

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Executor
import * from com::mulesoft::connectivity::flow::decorator::Executor

fun mapInputAndOutputQueryBuilderOperation<OpParam, OpResultType, OpResultErrorType <: ResultFailure, OpConnectionType, NewOpParam, NewOpResultType, NewOpResultErrorType <: ResultFailure>(
    operation: Operation<OpParam, OpResultType, OpResultErrorType, OpConnectionType>,
    inputMapper: (NewOpParam) -> OpParam,
    outputSuccessMapper: (OpResultType, NewOpParam) -> NewOpResultType,
    outputFailureMapper: (OpResultErrorType) -> NewOpResultErrorType
    ): Operation<NewOpParam, NewOpResultType, NewOpResultErrorType, OpConnectionType> = do {
        operation update { case executor at .executor -> mapQueryBuilderResult(mapInput(operation.executor, inputMapper), outputSuccessMapper, outputFailureMapper)
        }
}

fun mapOutputQueryBuilderOperation<OpParam, OpResultType, OpResultErrorType <: ResultFailure, OpConnectionType, NewOpResultType, NewOpResultErrorType <: ResultFailure>(
    operation: Operation<OpParam, OpResultType, OpResultErrorType, OpConnectionType>,
    outputSuccessMapper: (OpResultType, OpParam) -> NewOpResultType,
    outputFailureMapper: (OpResultErrorType) -> NewOpResultErrorType
    ): Operation<OpParam, NewOpResultType, NewOpResultErrorType, OpConnectionType> = do {
        operation update { case executor at .executor -> mapQueryBuilderResult(operation.executor, outputSuccessMapper, outputFailureMapper)
        }
}
