/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.maven.api.mojo;

import com.google.gson.Gson;
import com.mulesoft.connectivity.flow.maven.api.model.fasttrack.auth.SalesforceTargetOrgs;
import com.mulesoft.connectivity.flow.maven.api.mojo.AbstractFlowMojo;
import com.mulesoft.connectivity.flow.maven.internal.sf.FastTrack;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.jspecify.annotations.Nullable;

@Mojo(name="flowFastTrack", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class FlowFastTrackMojo
extends AbstractFlowMojo {
    @Parameter(property="skipFlowFastTrack")
    private boolean skipFlowFastTrack;
    @Parameter(defaultValue="${project.name}")
    private String name = "";
    @Parameter(defaultValue="${project.resources[0].directory}/fastTrackOrganizations.json")
    private String salesforceTargetOrgsFile;
    @Parameter
    private @Nullable SalesforceTargetOrgs salesforceTargetOrgs;
    @Parameter
    private boolean failIfFastTrackFails = false;

    public void execute() throws MojoExecutionException {
        block7: {
            if (this.skipFlowFastTrack) {
                this.getLog().info((CharSequence)"Flow FastTrack Skipped");
                return;
            }
            if (this.name.isEmpty()) {
                this.getLog().error((CharSequence)"Invalid Name");
                throw new MojoExecutionException("Invalid Static Resource Name");
            }
            try {
                ArrayList<SalesforceTargetOrgs> targetOrgs = new ArrayList<SalesforceTargetOrgs>();
                if (this.salesforceTargetOrgs != null && !this.salesforceTargetOrgs.isEmpty()) {
                    targetOrgs.add(this.salesforceTargetOrgs);
                }
                if (!this.salesforceTargetOrgsFile.isEmpty()) {
                    targetOrgs.add(this.loadTargetOrgsFile());
                }
                if (targetOrgs.isEmpty()) {
                    this.getLog().error((CharSequence)"No organizations set up");
                    throw new MojoExecutionException("Invalid configuration. You need to set at least one FastTrack org.");
                }
                FastTrack fastTrack = FastTrack.builder().organizationsSources(targetOrgs).failIfFastTrackFails(this.failIfFastTrackFails).log(this.getLog()).build();
                fastTrack.publish(this.name, this.getArtifactFile());
                this.writeMojoResult(Phase.FAST_TRACK_DEPLOY, Status.SUCCESS);
            }
            catch (Exception ex) {
                this.writeMojoResult(Phase.FAST_TRACK_DEPLOY, Status.FAILURE, ex, Collections.emptyMap());
                if (!this.failIfFastTrackFails) break block7;
                throw new MojoExecutionException("Failed to FastTrack Flow Connector: " + ex.getMessage(), ex);
            }
        }
    }

    private File getArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        File pomFile = this.project.getFile();
        ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
        artifact.addMetadata((ArtifactMetadata)metadata);
        return artifact.getFile();
    }

    private SalesforceTargetOrgs loadTargetOrgsFile() throws IllegalArgumentException, MojoExecutionException {
        File file = new File(this.salesforceTargetOrgsFile);
        if (!file.exists()) {
            throw new IllegalArgumentException("Salesforce Target Orgs File does not exist: " + this.salesforceTargetOrgsFile);
        }
        try {
            return (SalesforceTargetOrgs)new Gson().fromJson((Reader)new FileReader(file), SalesforceTargetOrgs.class);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read Salesforce Target Orgs File: " + e.getMessage(), e);
        }
    }

    @Generated
    public void setSkipFlowFastTrack(boolean skipFlowFastTrack) {
        this.skipFlowFastTrack = skipFlowFastTrack;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSalesforceTargetOrgsFile(String salesforceTargetOrgsFile) {
        this.salesforceTargetOrgsFile = salesforceTargetOrgsFile;
    }

    @Generated
    public void setSalesforceTargetOrgs(@Nullable SalesforceTargetOrgs salesforceTargetOrgs) {
        this.salesforceTargetOrgs = salesforceTargetOrgs;
    }

    @Generated
    public void setFailIfFastTrackFails(boolean failIfFastTrackFails) {
        this.failIfFastTrackFails = failIfFastTrackFails;
    }

    @Generated
    public boolean isSkipFlowFastTrack() {
        return this.skipFlowFastTrack;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSalesforceTargetOrgsFile() {
        return this.salesforceTargetOrgsFile;
    }

    @Generated
    public @Nullable SalesforceTargetOrgs getSalesforceTargetOrgs() {
        return this.salesforceTargetOrgs;
    }

    @Generated
    public boolean isFailIfFastTrackFails() {
        return this.failIfFastTrackFails;
    }
}

