/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.maven.api.mojo;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorDescriptorModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.persistence.FlowModelSerializer;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializer;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializerFactory;
import com.mulesoft.connectivity.flow.api.servicemodel.SalesforceRelease;
import com.mulesoft.connectivity.flow.internal.connection.Connections;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionsFactory;
import com.mulesoft.connectivity.flow.maven.api.mojo.AbstractFlowMojo;
import com.mulesoft.connectivity.flow.maven.internal.semver.Semver;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;

@Mojo(name="createFlowStaticMetaData", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class FlowStaticModelMojo
extends AbstractFlowMojo {
    @Parameter(property="staticModelDirectory", defaultValue="${project.build.directory}/classes/META-INF")
    private String staticModelDirectory;
    @Parameter(property="staticModelFile", defaultValue="flow-connector.ic")
    private String staticModelFile;
    @Parameter(property="connectionsFile", defaultValue="connections.json")
    private String connectionsFile;
    @Parameter(defaultValue="false")
    private boolean skipStaticModel;
    @Parameter(property="releaseStatus", required=true)
    private String releaseStatus;
    @Parameter(defaultValue="false")
    private boolean skipServiceModel;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private ReleaseServiceModelSerializerFactory releaseServiceModelSerializerFactory = new ReleaseServiceModelSerializerFactory();
    private static final String CONNECTOR_INFO = "\n*****************\nName: %s\nDisplay Name: %s\nDeveloper Name: %s\nVersion: %s\nSince: %s\n*****************\n";
    private static final String DEVELOPER_NAME_FORMAT = "%s_%s";
    private boolean testing = false;

    void enableTesting() {
        this.testing = true;
    }

    public void execute() throws MojoExecutionException {
        if (this.skipStaticModel) {
            this.getLog().info((CharSequence)"Static model generation skipped");
            return;
        }
        try {
            FlowStaticModelMojo.withContextClassLoader((ClassLoader)this.getCustomClassLoader(), () -> {
                SalesforceRelease since;
                FlowConnectorModel connectorModel;
                DataWeaveScriptingEngine dataWeaveEngine = this.getDwEngine(new ParserConfigurationBuilder().build());
                LanguageModelLoader flowLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), FLOW_CONNECTOR_ELEMENT);
                Semver version = new Semver(this.project.getVersion());
                ReleaseStatus releaseStatusEnum = ReleaseStatus.fromString((String)this.releaseStatus);
                if (this.testing) {
                    connectorModel = (FlowConnectorModel)flowLoader.loadConnector(this.dwRef, (Object)new FlowConnectorLoader.ExtraData(this.project.getVersion(), releaseStatusEnum, SalesforceRelease.R256.name()));
                    since = this.validateSince(SalesforceRelease.R256.name());
                } else {
                    connectorModel = (FlowConnectorModel)flowLoader.loadConnector(this.dwRef, (Object)new FlowConnectorLoader.ExtraData(this.project.getVersion(), releaseStatusEnum));
                    since = this.validateSince(connectorModel.getSince());
                }
                FlowConnectorDescriptorModel staticConnectorModel = this.createStaticModel(connectorModel, since, version, releaseStatusEnum);
                Connections simplifiedConnector = ConnectionsFactory.create().fromConnectorModel(connectorModel.getName(), connectorModel.getConnections().stream().map(c -> c).toList());
                this.writeConnectionsFile(simplifiedConnector);
                this.writeStaticModelFile(staticConnectorModel);
                this.writeSerializedModel(connectorModel);
                this.validateSerializedModel(connectorModel);
                this.writeMojoResult(Phase.PACKAGE, Status.SUCCESS);
                return null;
            });
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.PACKAGE, Status.FAILURE, ex, Collections.emptyMap());
            throw new MojoExecutionException("Failed to create the Flow Connector Static Model: " + ex.getMessage(), ex);
        }
    }

    @VisibleForTesting
    void setReleaseServiceModelSerializerFactory(ReleaseServiceModelSerializerFactory releaseServiceModelSerializerFactory) {
        this.releaseServiceModelSerializerFactory = releaseServiceModelSerializerFactory;
    }

    Map<String, String> generateServiceModels(FlowConnectorModel connectorModel, SalesforceRelease releaseTarget) throws IOException, MojoExecutionException {
        List releaseServiceModelSerializers = this.releaseServiceModelSerializerFactory.getSerializersFor(releaseTarget);
        if (releaseServiceModelSerializers.isEmpty()) {
            this.getLog().warn((CharSequence)("No release serializer found for " + connectorModel.getName()));
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (ReleaseServiceModelSerializer serializer : releaseServiceModelSerializers) {
            String fileName = connectorModel.getDeveloperName() + "." + serializer.getSalesforceRelease().getSuffix();
            try {
                Writer writer = this.getFileWriter(this.getModelFilePath(fileName));
                try {
                    serializer.serialize(connectorModel, writer);
                    result.put(serializer.getSalesforceRelease().name(), fileName);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Failed to generate service model", (Throwable)ex);
                throw ex;
            }
        }
        return result;
    }

    FlowConnectorDescriptorModel createStaticModel(FlowConnectorModel connectorModel, SalesforceRelease since, Semver version, ReleaseStatus releaseStatusEnum) throws MojoExecutionException, IOException {
        if (connectorModel.getVendor().isEmpty()) {
            throw new IllegalArgumentException("Vendor cannot be empty");
        }
        ZonedDateTime now = ZonedDateTime.now();
        this.validateReleaseStatus(version, releaseStatusEnum);
        FlowConnectorDescriptorModel staticConnectorModel = new FlowConnectorDescriptorModel.Builder().fromConnectorModel(connectorModel).withCreatedDate(now).withLastModifiedDate(now).withVersion(version.toString()).withVendor(connectorModel.getVendor()).withServiceModels(this.generateServiceModels(connectorModel, since)).build();
        this.getLog().info((CharSequence)String.format(CONNECTOR_INFO, staticConnectorModel.getName(), staticConnectorModel.getDisplayName(), staticConnectorModel.getDeveloperName(), staticConnectorModel.getVersion(), since.name()));
        return staticConnectorModel;
    }

    private void validateReleaseStatus(Semver version, ReleaseStatus releaseStatus) {
        boolean versionIsGA;
        boolean bl = versionIsGA = Semver.VERSION_1_0_0.compareTo(version) <= 0;
        if (releaseStatus == ReleaseStatus.GA && !versionIsGA) {
            throw new IllegalArgumentException("Release status is GA, but the version '" + String.valueOf(version) + "' is less than 1.0.0");
        }
        if (releaseStatus != ReleaseStatus.GA && versionIsGA) {
            throw new IllegalArgumentException("Release status is not GA, but the version '" + String.valueOf(version) + "' is equals or greater than 1.0.0");
        }
    }

    private void writeSerializedModel(FlowConnectorModel connectorModel) throws MojoExecutionException {
        FlowModelSerializer serializer = new FlowModelSerializer();
        String fileName = connectorModel.getDeveloperName() + ".ic";
        Path serializedModelPath = this.getModelFilePath(fileName);
        try (Writer serializedModelWriter = this.getFileWriter(serializedModelPath);){
            serializer.serialize(connectorModel, serializedModelWriter);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void validateSerializedModel(FlowConnectorModel connectorModel) throws MojoExecutionException {
        String fileName = connectorModel.getDeveloperName() + ".ic";
        Path serializedModelPath = this.getModelFilePath(fileName);
        FlowModelSerializer serializer = new FlowModelSerializer();
        try (FileReader serializedModelReader = new FileReader(serializedModelPath.toFile());){
            serializer.deserialize((Map)this.gson.fromJson((Reader)serializedModelReader, Object.class));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failures while validating deserialization:" + ex.getMessage(), ex);
        }
    }

    @VisibleForTesting
    SalesforceRelease validateSince(String since) {
        try {
            return SalesforceRelease.valueOf((String)since.trim());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid since value: '%s'. Valid values are: %s", since, Arrays.stream(SalesforceRelease.values()).map(Enum::name).collect(Collectors.joining(", "))), e);
        }
    }

    private void writeStaticModelFile(FlowConnectorDescriptorModel model) throws MojoExecutionException {
        String modelJson = this.gson.toJson((Object)model);
        Path modelFilePath = Path.of(this.staticModelDirectory, new String[0]).resolve(this.staticModelFile);
        try {
            Files.createDirectories(modelFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while creating parent directories of %s", modelFilePath), (Exception)e);
        }
        try (FileWriter writer = new FileWriter(modelFilePath.toString());){
            writer.write(modelJson);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while writing to %s", modelFilePath), (Exception)e);
        }
    }

    private void writeConnectionsFile(Connections connections) throws MojoExecutionException {
        String modelJson = this.gson.toJson((Object)connections);
        Path modelFilePath = Path.of(this.staticModelDirectory, new String[0]).resolve(this.connectionsFile);
        try {
            Files.createDirectories(modelFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while creating parent directories of %s", modelFilePath), (Exception)e);
        }
        try (FileWriter writer = new FileWriter(modelFilePath.toString());){
            writer.write(modelJson);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while writing to %s", modelFilePath), (Exception)e);
        }
    }

    private Path getModelFilePath(String fileName) {
        return Path.of(this.staticModelDirectory, new String[0]).resolve(fileName);
    }

    private Writer getFileWriter(Path filePath) throws MojoExecutionException {
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            return new FileWriter(filePath.toFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while creating parent directories of %s", filePath), (Exception)e);
        }
    }

    protected String formatDeveloperName(String developerName) {
        if (this.project.getVersion() == null) {
            return developerName;
        }
        String projectMajorVersion = this.project.getVersion().split("\\.")[0];
        try {
            int majorVersion = Integer.parseInt(projectMajorVersion);
            if (majorVersion > 1) {
                developerName = String.format(DEVELOPER_NAME_FORMAT, developerName, projectMajorVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return developerName;
    }

    @Generated
    public void setStaticModelDirectory(String staticModelDirectory) {
        this.staticModelDirectory = staticModelDirectory;
    }

    @Generated
    public void setStaticModelFile(String staticModelFile) {
        this.staticModelFile = staticModelFile;
    }

    @Generated
    public void setConnectionsFile(String connectionsFile) {
        this.connectionsFile = connectionsFile;
    }

    @Generated
    public void setSkipStaticModel(boolean skipStaticModel) {
        this.skipStaticModel = skipStaticModel;
    }

    @Generated
    public void setReleaseStatus(String releaseStatus) {
        this.releaseStatus = releaseStatus;
    }
}

