/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.maven.api.mojo;

import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.validator.FlowValidationConfiguration;
import com.mulesoft.connectivity.flow.maven.api.mojo.AbstractFlowMojo;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import com.mulesoft.connectivity.validation.ConnectorValidationAnnotationProcessor;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import java.util.Collections;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ParserConfiguration;

@Mojo(name="validateConnectorModel", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class FlowValidationMojo
extends AbstractFlowMojo {
    @Parameter(property="skipFlowModelValidation")
    private boolean skipFlowModelValidation;

    public void execute() throws MojoExecutionException {
        if (this.skipFlowModelValidation) {
            return;
        }
        try {
            FlowValidationMojo.withContextClassLoader((ClassLoader)this.getCustomClassLoader(), () -> {
                ParserConfiguration parserConfiguration = ConnectorValidationAnnotationProcessor.getParserConfigurationForValidation((NameIdentifier)FLOW_CONNECTOR_ELEMENT, (ValidationConfiguration)new FlowValidationConfiguration());
                DataWeaveScriptingEngine dataWeaveEngine = this.getDwEngine(parserConfiguration);
                LanguageModelLoader flowLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), FLOW_CONNECTOR_ELEMENT);
                flowLoader.loadConnector(this.dwRef, (Object)new FlowConnectorLoader.ExtraData("0.0.1", ReleaseStatus.PILOT));
                this.writeMojoResult(Phase.VALIDATE, Status.SUCCESS);
                return null;
            });
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.PACKAGE, Status.FAILURE, ex, Collections.emptyMap());
            throw new MojoExecutionException("Failed to create the Flow Connector Static Model: " + ex.getMessage(), ex);
        }
    }

    @Generated
    public void setSkipFlowModelValidation(boolean skipFlowModelValidation) {
        this.skipFlowModelValidation = skipFlowModelValidation;
    }
}

