/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.maven.internal.semver;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Semver
implements Comparable<Semver> {
    private final int major;
    private final int minor;
    private final int patch;
    private final @Nullable String preRelease;
    private final @Nullable String buildMetadata;
    private static final String SEMVER_REGEX;
    private static final Pattern SEMVER_PATTERN;
    public static final Semver VERSION_1_0_0;

    public Semver(String version) {
        Matcher matcher = SEMVER_PATTERN.matcher(Objects.requireNonNull(version));
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Version is not a semantic version: " + version + ". Please use a valid semantic version (e.g. 1.0.0, 1.0.0-alpha, 1.0.0-alpha.1, etc).");
        }
        this.major = Integer.parseInt(Objects.requireNonNull(matcher.group(1)));
        this.minor = Integer.parseInt(Objects.requireNonNull(matcher.group(2)));
        this.patch = Integer.parseInt(Objects.requireNonNull(matcher.group(3)));
        this.preRelease = matcher.group(4);
        this.buildMetadata = matcher.group(5);
    }

    public static boolean isValid(@Nullable String version) {
        return version != null && SEMVER_PATTERN.matcher(version).matches();
    }

    public boolean hasPreRelease() {
        return this.preRelease != null && !this.preRelease.isEmpty();
    }

    public static boolean hasPreRelease(String version) {
        if (!Semver.isValid(version)) {
            return false;
        }
        return new Semver(version).hasPreRelease();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public @Nullable String getPreRelease() {
        return this.preRelease;
    }

    public @Nullable String getBuildMetadata() {
        return this.buildMetadata;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.preRelease != null && !this.preRelease.isEmpty()) {
            result.append('-').append(this.preRelease);
        }
        if (this.buildMetadata != null && !this.buildMetadata.isEmpty()) {
            result.append('+').append(this.buildMetadata);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Semver semver = (Semver)o;
        return this.major == semver.major && this.minor == semver.minor && this.patch == semver.patch && Objects.equals(this.preRelease, semver.preRelease) && Objects.equals(this.buildMetadata, semver.buildMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.preRelease, this.buildMetadata);
    }

    @Override
    public int compareTo(Semver other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        if (this.preRelease != null && other.preRelease != null) {
            String[] arr1 = this.preRelease.split("\\.");
            String[] arr2 = other.preRelease.split("\\.");
            for (int i = 0; i < Math.max(arr1.length, arr2.length); ++i) {
                String component2;
                String component1 = i < arr1.length ? arr1[i] : null;
                int result = Semver.comparePreReleaseComponent(component1, component2 = i < arr2.length ? arr2[i] : null);
                if (result == 0) continue;
                return result;
            }
        } else {
            if (other.preRelease != null) {
                return 1;
            }
            if (this.preRelease != null) {
                return -1;
            }
        }
        return Objects.compare(this.buildMetadata, other.buildMetadata, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    private static Integer comparePreReleaseComponent(@Nullable String p1, @Nullable String p2) {
        if (p1 != null && p2 != null) {
            boolean p1IsNumeric = p1.matches("\\d+");
            boolean p2IsNumeric = p2.matches("\\d+");
            if (p1IsNumeric && p2IsNumeric) {
                return Integer.compare(Integer.parseInt(p1), Integer.parseInt(p2));
            }
            if (!p1IsNumeric && !p2IsNumeric) {
                return p1.compareTo(p2);
            }
            return p1IsNumeric ? -1 : 1;
        }
        if (p1 != null) {
            return -1;
        }
        if (p2 != null) {
            return 1;
        }
        return 0;
    }

    static {
        String number = "0|[1-9]\\d*";
        String capturedNumber = "(" + number + ")";
        String dot = "\\.";
        String version = capturedNumber + dot + capturedNumber + dot + capturedNumber;
        String preReleaseIdentifier = "(?:" + number + "|\\d*[a-zA-Z-][0-9a-zA-Z-]*)";
        String maybePreRelease = "(?:-(" + preReleaseIdentifier + "(?:\\." + preReleaseIdentifier + ")*))?";
        String buildIdentifier = "[0-9a-zA-Z-]+";
        String maybeBuildMetadata = "(?:\\+(" + buildIdentifier + "(?:\\." + buildIdentifier + ")*))?";
        SEMVER_REGEX = "^" + version + maybePreRelease + maybeBuildMetadata + "$";
        SEMVER_PATTERN = Pattern.compile(SEMVER_REGEX);
        VERSION_1_0_0 = new Semver("1.0.0");
    }
}

