/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.maven.internal.sf;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mulesoft.connectivity.flow.maven.api.model.fasttrack.auth.AbstractAuthenticationType;
import com.mulesoft.connectivity.flow.maven.api.model.fasttrack.auth.SalesforceTargetOrgs;
import com.mulesoft.connectivity.flow.maven.internal.sf.auth.SFAuth;
import com.mulesoft.connectivity.flow.maven.internal.sf.auth.SFAuthFactory;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.maven.plugin.logging.Log;

public class FastTrack {
    private static final String PAYLOAD_TEMPLATE = "{\n   \"ContentType\": \"%s\",\n   \"Name\": \"%s\",\n   \"Body\": \"%s\"\n}";
    private static final String DEFAULT_CONTENT_TYPE = "application/java-archive";
    private static final String STATIC_RESOURCE_UPLOAD_ENDPOINT = "services/data/v53.0/sobjects/staticResource";
    private static final String STATIC_RESOURCE_QUERY_ENDPOINT = "services/data/v62.0/query?q=Select%%20Id%%2C%%20Name%%20from%%20StaticResource%%20where%%20name%%20%%3D%%20%%27%s%%27";
    private static final String STATIC_RESOURCE_PATCH_ENDPOINT = "services/data/v62.0/sobjects/staticResource/%s";
    private final List<SalesforceTargetOrgs> organizationsSources;
    private final boolean failIfFastTrackFails;
    private final Log log;

    public void publish(String name, File content) {
        this.organizationsSources.stream().filter(Objects::nonNull).forEach(organizationSource -> organizationSource.getAll().forEach(organization -> {
            block2: {
                try {
                    this.doPublish((AbstractAuthenticationType)organization, name, content);
                }
                catch (Exception e) {
                    this.log.error((CharSequence)("Message: " + e.getMessage()), (Throwable)e);
                    if (!this.failIfFastTrackFails) break block2;
                    throw new RuntimeException("Failed to FastTrack Connector: " + e.getMessage(), e);
                }
            }
        }));
    }

    private void doPublish(AbstractAuthenticationType organization, String name, File artifactFile) throws Exception {
        SFAuth auth = SFAuthFactory.getAuth(organization);
        auth.authenticate();
        String staticResourceId = this.getStaticResourceId(auth, name);
        if (staticResourceId != null) {
            this.log.debug((CharSequence)"Updating static resource");
            this.patchStaticResource(auth, staticResourceId, name, artifactFile);
        } else {
            this.log.debug((CharSequence)"Creating new static resource");
            this.createNewStaticResource(auth, name, artifactFile);
        }
    }

    private String getStaticResourceId(SFAuth auth, String name) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        String sanitizedName = this.sanitizeName(name);
        HttpRequest.Builder queryRequestBuilder = HttpRequest.newBuilder().uri(this.sanitizeUri(auth.getInstanceURI(), String.format(STATIC_RESOURCE_QUERY_ENDPOINT, sanitizedName)));
        queryRequestBuilder = auth.authorize(queryRequestBuilder);
        queryRequestBuilder.header("Content-Type", "application/json");
        HttpRequest queryRequest = queryRequestBuilder.GET().build();
        HttpResponse<String> queryResponse = client.send(queryRequest, HttpResponse.BodyHandlers.ofString());
        if (queryResponse.statusCode() != 200) {
            throw new Exception("Failed to query if the artifact exists: " + queryResponse.statusCode() + " " + queryResponse.body());
        }
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map queryResponseMap = (Map)gson.fromJson(queryResponse.body(), type);
        List records = (List)queryResponseMap.get("records");
        if (records != null && records.size() == 1) {
            return (String)((Map)records.get(0)).get("Id");
        }
        return null;
    }

    private void createNewStaticResource(SFAuth auth, String name, File artifactFile) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder uploadRequestBuilder = HttpRequest.newBuilder().uri(this.sanitizeUri(auth.getInstanceURI(), STATIC_RESOURCE_UPLOAD_ENDPOINT));
        uploadRequestBuilder = auth.authorize(uploadRequestBuilder);
        uploadRequestBuilder.header("Content-Type", "application/json");
        try (FileInputStream artifactContents = new FileInputStream(artifactFile);){
            String contents = Base64.getEncoder().encodeToString(artifactContents.readAllBytes());
            String sanitizedName = this.sanitizeName(name);
            String payload = String.format(PAYLOAD_TEMPLATE, DEFAULT_CONTENT_TYPE, sanitizedName, contents);
            HttpRequest uploadRequest = uploadRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(payload)).build();
            HttpResponse<String> uploadResponse = client.send(uploadRequest, HttpResponse.BodyHandlers.ofString());
            if (uploadResponse.statusCode() != 201) {
                throw new Exception("Failed to upload the artifact: " + uploadResponse.statusCode() + " " + uploadResponse.body());
            }
            this.log.info((CharSequence)("Successfully FastTracked the Connector: " + sanitizedName));
        }
    }

    private void patchStaticResource(SFAuth auth, String staticResourceId, String name, File artifactFile) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder uploadRequestBuilder = HttpRequest.newBuilder().uri(this.sanitizeUri(auth.getInstanceURI(), String.format(STATIC_RESOURCE_PATCH_ENDPOINT, staticResourceId)));
        uploadRequestBuilder = auth.authorize(uploadRequestBuilder);
        uploadRequestBuilder.header("Content-Type", "application/json");
        try (FileInputStream artifactContents = new FileInputStream(artifactFile);){
            String contents = Base64.getEncoder().encodeToString(artifactContents.readAllBytes());
            String sanitizedName = this.sanitizeName(name);
            String payload = String.format(PAYLOAD_TEMPLATE, DEFAULT_CONTENT_TYPE, sanitizedName, contents);
            HttpRequest uploadRequest = uploadRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofString(payload)).build();
            HttpResponse<String> uploadResponse = client.send(uploadRequest, HttpResponse.BodyHandlers.ofString());
            if (uploadResponse.statusCode() != 204) {
                throw new Exception("Failed to upload the artifact: " + uploadResponse.statusCode() + " " + uploadResponse.body());
            }
            this.log.info((CharSequence)("Successfully FastTracked the Connector: " + sanitizedName));
        }
    }

    private String sanitizeName(String name) {
        return name.replace("-", "");
    }

    private URI sanitizeUri(URI orgUrl, String endpoint) {
        if (orgUrl.toString().endsWith("/")) {
            return URI.create(String.valueOf(orgUrl) + endpoint);
        }
        return URI.create(String.valueOf(orgUrl) + "/" + endpoint);
    }

    @Generated
    FastTrack(List<SalesforceTargetOrgs> organizationsSources, boolean failIfFastTrackFails, Log log) {
        this.organizationsSources = organizationsSources;
        this.failIfFastTrackFails = failIfFastTrackFails;
        this.log = log;
    }

    @Generated
    public static FastTrackBuilder builder() {
        return new FastTrackBuilder();
    }

    @Generated
    public static class FastTrackBuilder {
        @Generated
        private List<SalesforceTargetOrgs> organizationsSources;
        @Generated
        private boolean failIfFastTrackFails;
        @Generated
        private Log log;

        @Generated
        FastTrackBuilder() {
        }

        @Generated
        public FastTrackBuilder organizationsSources(List<SalesforceTargetOrgs> organizationsSources) {
            this.organizationsSources = organizationsSources;
            return this;
        }

        @Generated
        public FastTrackBuilder failIfFastTrackFails(boolean failIfFastTrackFails) {
            this.failIfFastTrackFails = failIfFastTrackFails;
            return this;
        }

        @Generated
        public FastTrackBuilder log(Log log) {
            this.log = log;
            return this;
        }

        @Generated
        public FastTrack build() {
            return new FastTrack(this.organizationsSources, this.failIfFastTrackFails, this.log);
        }

        @Generated
        public String toString() {
            return "FastTrack.FastTrackBuilder(organizationsSources=" + String.valueOf(this.organizationsSources) + ", failIfFastTrackFails=" + this.failIfFastTrackFails + ", log=" + String.valueOf(this.log) + ")";
        }
    }
}

