/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.maven.internal.sf.auth;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mulesoft.connectivity.flow.maven.api.model.fasttrack.auth.UserNamePassword;
import com.mulesoft.connectivity.flow.maven.internal.sf.auth.SFAuth;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import lombok.Generated;

public class UserNamePasswordAuth
implements SFAuth {
    private static final String FORM_TEMPLATE = "grant_type=password&username=%s&password=%s&client_id=%s&client_secret=%s";
    private static final String TOKEN_URL_TEMPLATE = "%s/services/oauth2/token";
    private final UserNamePassword authInfo;
    private String accessToken;
    private URI instanceUrl;
    private final String tokenUrl;
    private final HttpClient authHttpClient;

    @Override
    public HttpRequest.Builder authorize(HttpRequest.Builder requestBuilder) throws Exception {
        if (this.accessToken == null) {
            this.authenticate();
        }
        requestBuilder.header("Authorization", "Bearer " + this.accessToken);
        return requestBuilder;
    }

    @Override
    public URI getInstanceURI() {
        return this.instanceUrl;
    }

    @Override
    public void authenticate() throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        String formData = String.format(FORM_TEMPLATE, this.authInfo.getUserName(), this.authInfo.getPassword(), this.authInfo.getConsumerKey(), this.authInfo.getConsumerSecret());
        HttpRequest authRequest = HttpRequest.newBuilder().uri(URI.create(this.getTokenUrl())).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(formData)).build();
        try {
            HttpResponse<String> authResponse = client.send(authRequest, HttpResponse.BodyHandlers.ofString());
            assert (authResponse.statusCode() == 200) : "Authentication Failed with Code: " + authResponse.statusCode();
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map tokenResponse = (Map)gson.fromJson(authResponse.body(), type);
            this.accessToken = (String)tokenResponse.get("access_token");
            this.instanceUrl = new URI((String)tokenResponse.get("instance_url"));
        }
        catch (ConnectException e) {
            throw new Exception("Failed to connect to " + String.valueOf(authRequest.uri()), e);
        }
    }

    private String getTokenUrl() {
        return String.format(TOKEN_URL_TEMPLATE, this.authInfo.getAuthorizationServer());
    }

    @Generated
    UserNamePasswordAuth(UserNamePassword authInfo, String accessToken, URI instanceUrl, String tokenUrl, HttpClient authHttpClient) {
        this.authInfo = authInfo;
        this.accessToken = accessToken;
        this.instanceUrl = instanceUrl;
        this.tokenUrl = tokenUrl;
        this.authHttpClient = authHttpClient;
    }

    @Generated
    public static UserNamePasswordAuthBuilder builder() {
        return new UserNamePasswordAuthBuilder();
    }

    @Generated
    public static class UserNamePasswordAuthBuilder {
        @Generated
        private UserNamePassword authInfo;
        @Generated
        private String accessToken;
        @Generated
        private URI instanceUrl;
        @Generated
        private String tokenUrl;
        @Generated
        private HttpClient authHttpClient;

        @Generated
        UserNamePasswordAuthBuilder() {
        }

        @Generated
        public UserNamePasswordAuthBuilder authInfo(UserNamePassword authInfo) {
            this.authInfo = authInfo;
            return this;
        }

        @Generated
        public UserNamePasswordAuthBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Generated
        public UserNamePasswordAuthBuilder instanceUrl(URI instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        @Generated
        public UserNamePasswordAuthBuilder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        @Generated
        public UserNamePasswordAuthBuilder authHttpClient(HttpClient authHttpClient) {
            this.authHttpClient = authHttpClient;
            return this;
        }

        @Generated
        public UserNamePasswordAuth build() {
            return new UserNamePasswordAuth(this.authInfo, this.accessToken, this.instanceUrl, this.tokenUrl, this.authHttpClient);
        }

        @Generated
        public String toString() {
            return "UserNamePasswordAuth.UserNamePasswordAuthBuilder(authInfo=" + String.valueOf(this.authInfo) + ", accessToken=" + this.accessToken + ", instanceUrl=" + String.valueOf(this.instanceUrl) + ", tokenUrl=" + this.tokenUrl + ", authHttpClient=" + String.valueOf(this.authHttpClient) + ")";
        }
    }
}

