/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer.check.types;

import com.mulesoft.connectivity.flow.api.analyzer.AttachmentUtils;
import com.mulesoft.connectivity.flow.api.analyzer.ModelDifference;
import com.mulesoft.connectivity.flow.api.analyzer.check.BaseCheck;
import com.mulesoft.connectivity.flow.api.analyzer.check.Type;
import com.mulesoft.connectivity.flow.api.analyzer.element.InputTypeModelElement;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.revapi.Difference;

public class InputTypeRequiredPropertyAdded
extends BaseCheck {
    @Override
    public EnumSet<Type> getInterest() {
        return EnumSet.of(Type.INPUT_TYPE);
    }

    @Override
    protected void doVisitInputType(@Nullable InputTypeModelElement oldElement, @Nullable InputTypeModelElement newElement) {
        if (oldElement == null || newElement == null) {
            return;
        }
        DWType oldWeaveType = TypeUtils.resolveReferenceType((DWType)((TypeModel)oldElement.getModel()).getDataType());
        DWType newWeaveType = TypeUtils.resolveReferenceType((DWType)((TypeModel)newElement.getModel()).getDataType());
        if (oldWeaveType instanceof ObjectType) {
            ObjectType oldInputType = (ObjectType)oldWeaveType;
            if (newWeaveType instanceof ObjectType) {
                ObjectType newInputType = (ObjectType)newWeaveType;
                List<String> oldFields = Arrays.stream(oldInputType.getProperties()).map(f -> ((KeyType)f.getKey()).getName().toString()).toList();
                Arrays.stream(newInputType.getProperties()).filter(f -> !oldFields.contains(((KeyType)f.getKey()).getName().toString())).filter(f -> !f.isOptionalKey()).findFirst().ifPresent(e -> this.pushActive(oldElement, newElement));
            }
        }
    }

    @Override
    protected List<Difference> doEnd() {
        BaseCheck.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createDifference(ModelDifference.INPUT_TYPE_REQUIRED_PROPERTY_ADDED, AttachmentUtils.attachmentsFor(methods.oldElement, methods.newElement, new String[0])));
    }
}

