/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer;

import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AttachmentUtils {
    private AttachmentUtils() {
    }

    public static <T extends ModelElement> Map<String, String> attachmentsFor(T oldElement, T newElement, String ... customAttachments) {
        T representative;
        T t = representative = oldElement == null ? newElement : oldElement;
        if (representative == null) {
            throw new IllegalArgumentException("At least one of the oldElement and newElement must not be null");
        }
        LinkedHashMap<String, String> attachments = AttachmentUtils.keyValues(customAttachments);
        attachments.putAll(representative.getAttachments());
        return attachments;
    }

    private static LinkedHashMap<String, String> keyValues(String ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Uneven key-value pairs.");
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            ret.put(Objects.requireNonNull(keyValues[i], "Null keys not supported in attachments."), keyValues[i + 1]);
        }
        return ret;
    }
}

