/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer;

import com.mulesoft.connectivity.flow.api.analyzer.element.ConnectorModelElement;
import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import com.mulesoft.connectivity.flow.run.IncompleteConnectorException;
import com.mulesoft.connectivity.flow.run.LoadedConnector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.revapi.API;
import org.revapi.ApiAnalyzer;
import org.revapi.Archive;
import org.revapi.base.BaseArchiveAnalyzer;
import org.revapi.base.BaseElementForest;

class ModelArchiveAnalyzer
extends BaseArchiveAnalyzer<BaseElementForest<ModelElement>, ModelElement> {
    ModelArchiveAnalyzer(ApiAnalyzer<ModelElement> modelApiAnalyzer, API api) {
        super(modelApiAnalyzer, api);
    }

    protected BaseElementForest<ModelElement> newElementForest() {
        return new BaseElementForest(this.getApi());
    }

    protected Stream<ModelElement> discoverRoots(@Nullable Object context) {
        Stream<ModelElement> stream;
        IdentityHashMap<URL, Archive> sources = new IdentityHashMap<URL, Archive>();
        for (Archive archive : this.getApi().getArchives()) {
            try {
                byte[] bytes;
                try (InputStream archiveStream = archive.openStream();){
                    bytes = archiveStream.readAllBytes();
                }
                File tempFile = File.createTempFile("jar-file", ".jar");
                tempFile.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(tempFile);){
                    new ByteArrayInputStream(bytes).transferTo(out);
                }
                sources.put(tempFile.toURI().toURL(), archive);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LoadedConnector loadedConnector = new LoadedConnector(sources.keySet(), new DataWeaveScriptingEngine());
        try {
            stream = Stream.of(new ConnectorModelElement(this.getApi(), (Archive)sources.get(loadedConnector.getMainJar()), loadedConnector.getConnectorModel()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    loadedConnector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IncompleteConnectorException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IOException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        loadedConnector.close();
        return stream;
    }

    protected Stream<ModelElement> discoverElements(@Nullable Object context, ModelElement element) {
        return element.discoverElements().stream();
    }
}

