/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer;

import com.mulesoft.connectivity.flow.api.analyzer.check.Check;
import com.mulesoft.connectivity.flow.api.analyzer.check.Type;
import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Stats;
import org.revapi.base.BaseDifferenceAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelDifferenceAnalyzer
extends BaseDifferenceAnalyzer<ModelElement> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelDifferenceAnalyzer.class);
    private final Map<Type, List<Check>> checksByInterest;
    private final Deque<Type> typeStack = new ArrayDeque<Type>();
    private boolean nonExistenceMode;
    private ModelElement nonExistenceOldRoot;
    private ModelElement nonExistenceNewRoot;

    ModelDifferenceAnalyzer(Map<Type, List<Check>> checksByInterest) {
        this.checksByInterest = checksByInterest;
    }

    public void beginAnalysis(@Nullable ModelElement oldElement, @Nullable ModelElement newElement) {
        LOG.debug("Beginning analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        if (this.nonExistenceMode) {
            LOG.trace("Analysis of {} and {} is not done as it has been traversed during non existence mode, marked at {} and {}", new Object[]{oldElement, newElement, this.nonExistenceOldRoot, this.nonExistenceNewRoot});
        } else {
            this.checkElements(oldElement, newElement);
            if (!this.isDescendRequired(oldElement, newElement)) {
                this.nonExistenceMode = true;
                this.nonExistenceOldRoot = oldElement;
                this.nonExistenceNewRoot = newElement;
                LOG.trace("Starting non existence mode at {} and {} due to analyzer defines that it should not descend 'into' the two provided elements", (Object)this.nonExistenceOldRoot, (Object)this.nonExistenceNewRoot);
            }
        }
    }

    private void checkElements(@Nullable ModelElement oldElement, @Nullable ModelElement newElement) {
        Type type = this.getType(oldElement, newElement);
        this.typeStack.push(type);
        for (Check c : this.getChecksFor(type)) {
            Stats.of((String)c.getClass().getName()).start();
            type.applyCheck(c, oldElement, newElement);
            Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
        }
    }

    private Type getType(@Nullable ModelElement oldElement, @Nullable ModelElement newElement) {
        Type checkTypeNew;
        Type checkTypeOld = oldElement == null ? null : oldElement.getType();
        Type type = checkTypeNew = newElement == null ? null : newElement.getType();
        if (checkTypeOld == checkTypeNew) {
            if (checkTypeOld == null) {
                throw new IllegalStateException("At least one of the elements to check must be non null");
            }
        } else if (checkTypeOld != null && checkTypeNew != null) {
            throw new IllegalStateException(String.format("New and old elements must be of the same type. Found %s and %s", new Object[]{checkTypeOld, checkTypeNew}));
        }
        return checkTypeOld != null ? checkTypeOld : checkTypeNew;
    }

    private List<Check> getChecksFor(Type type) {
        List<Check> checks = this.checksByInterest.get((Object)type);
        return checks == null ? Collections.emptyList() : checks;
    }

    public Report endAnalysis(@Nullable ModelElement oldElement, @Nullable ModelElement newElement) {
        LOG.trace("Ending analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        Type elementsType = this.getType(oldElement, newElement);
        LOG.trace("Check.Type identified: {}", (Object)elementsType);
        if (oldElement == this.nonExistenceOldRoot && newElement == this.nonExistenceNewRoot) {
            LOG.trace("Leaving non existence mode at {} and {}", (Object)this.nonExistenceOldRoot, (Object)this.nonExistenceNewRoot);
            this.nonExistenceMode = false;
            this.nonExistenceOldRoot = null;
            this.nonExistenceNewRoot = null;
        }
        ArrayList differences = new ArrayList();
        if (!this.nonExistenceMode) {
            this.getChecksFor(this.typeStack.pop()).forEach(c -> differences.addAll(c.visitEnd()));
        }
        return new Report(differences, (Element)oldElement, (Element)newElement);
    }
}

