/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer.element;

import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import com.mulesoft.connectivity.flow.api.analyzer.element.RootModelElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.base.BaseElement;

public abstract class BaseModelElement<M>
extends BaseElement<ModelElement>
implements ModelElement {
    public static final String ELEMENT_KIND_ATTACHMENT = "elementKind";
    public static final String ELEMENT_NAME_ATTACHMENT = "elementName";
    public static final String NEW_VALUE_ATTACHMENT = "newValue";
    public static final String OLD_VALUE_ATTACHMENT = "oldValue";
    public static final String PATH_ATTACHMENT = "path";
    private final M model;

    BaseModelElement(API api, @Nullable Archive archive, @Nullable ModelElement parent, M model) {
        super(api, archive);
        if (parent == null && !(this instanceof RootModelElement)) {
            throw new IllegalArgumentException("A non root model element must have a parent defined");
        }
        this.setParent(parent);
        this.model = model;
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public List<ModelElement> discoverElements() {
        throw new IllegalStateException("There is no discovery of elements for " + this.getClass().getName());
    }

    @Override
    public String getPath() {
        ArrayList<String> elements = new ArrayList<String>();
        for (ModelElement current = this; current != null; current = (ModelElement)current.getParent()) {
            elements.add(current.getLocalPathName());
        }
        StringJoiner builder = new StringJoiner(".");
        for (int i = elements.size() - 1; i >= 0; --i) {
            builder.add((CharSequence)elements.get(i));
        }
        return builder.toString();
    }

    @Override
    public final Map<String, String> getAttachments() {
        HashMap<String, String> attachments = new HashMap<String, String>();
        attachments.put(PATH_ATTACHMENT, this.getPath());
        this.addAttachments(attachments);
        return attachments;
    }

    protected void addAttachments(Map<String, String> attachments) {
    }

    public int compareTo(ModelElement o) {
        if (this.getClass() != o.getClass()) {
            return this.getType().compareTo(o.getType());
        }
        return this.getPath().compareTo(o.getPath());
    }
}

