/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer.check.types;

import com.mulesoft.connectivity.flow.api.analyzer.check.BaseCheck;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.ts.WeaveType;

public abstract class TypeCheck
extends BaseCheck {
    private final Set<String> currentlyVisiting = new HashSet<String>();

    /*
     * Enabled aggressive block sorting
     */
    protected void compareTypesRecursive(@Nullable DWType oldType, @Nullable DWType newType) {
        if (oldType == null) return;
        if (newType == null) {
            return;
        }
        DWType resolvedOldType = this.resolveIfReference(oldType);
        DWType resolvedNewType = this.resolveIfReference(newType);
        if (resolvedOldType instanceof ObjectType) {
            ObjectType oldObjectType = (ObjectType)resolvedOldType;
            if (resolvedNewType instanceof ObjectType) {
                ObjectType newObjectType = (ObjectType)resolvedNewType;
                this.compareObjectTypes(oldObjectType, newObjectType);
                return;
            }
        }
        if (resolvedOldType instanceof ArrayType) {
            ArrayType oldArrayType = (ArrayType)resolvedOldType;
            if (resolvedNewType instanceof ArrayType) {
                ArrayType newArrayType = (ArrayType)resolvedNewType;
                this.compareTypesRecursive(oldArrayType.arrayOf(), newArrayType.arrayOf());
                return;
            }
        }
        if (resolvedOldType instanceof IntersectionType) {
            IntersectionType oldIntersectionType = (IntersectionType)resolvedOldType;
            if (resolvedNewType instanceof IntersectionType) {
                IntersectionType newIntersectionType = (IntersectionType)resolvedNewType;
                this.compareIntersectionTypes(oldIntersectionType, newIntersectionType);
                return;
            }
        }
        this.compareTypes(oldType, newType);
    }

    protected void compareObjectTypes(ObjectType oldObjectType, ObjectType newObjectType) {
        Set oldFields = Arrays.stream(oldObjectType.getProperties()).map(f -> ((KeyType)f.getKey()).getName().toString()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        for (KeyValuePairType newProperty : newObjectType.getProperties()) {
            String newFieldName = ((KeyType)newProperty.getKey()).getName().toString();
            if (!oldFields.contains(newFieldName)) continue;
            Arrays.stream(oldObjectType.getProperties()).filter(oldProp -> ((KeyType)oldProp.getKey()).getName().toString().equals(newFieldName)).findFirst().ifPresent(oldProp -> this.compareTypesRecursive(oldProp.getValue(), newProperty.getValue()));
        }
    }

    protected void compareIntersectionTypes(IntersectionType oldIntersectionType, IntersectionType newIntersectionType) {
        this.compareTypesRecursive((DWType)WeaveTypeSimplifier.resolveIntersection((WeaveType)((WeaveType)oldIntersectionType)), (DWType)WeaveTypeSimplifier.resolveIntersection((WeaveType)((WeaveType)newIntersectionType)));
    }

    private void compareTypes(DWType oldType, DWType newType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DWType resolveIfReference(DWType type) {
        ReferenceType referenceType;
        String referenceFQName;
        if (type instanceof ReferenceType && this.currentlyVisiting.add(referenceFQName = (referenceType = (ReferenceType)type).getReferenceFQName())) {
            try {
                DWType dWType = TypeUtils.resolveReferenceType((DWType)type);
                return dWType;
            }
            finally {
                this.currentlyVisiting.remove(referenceFQName);
            }
        }
        return type;
    }
}

