/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer;

import com.mulesoft.connectivity.flow.api.analyzer.ModelArchiveAnalyzer;
import com.mulesoft.connectivity.flow.api.analyzer.ModelDifferenceAnalyzer;
import com.mulesoft.connectivity.flow.api.analyzer.check.Check;
import com.mulesoft.connectivity.flow.api.analyzer.check.Type;
import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.ApiAnalyzer;
import org.revapi.ArchiveAnalyzer;
import org.revapi.DifferenceAnalyzer;
import org.revapi.base.BaseApiAnalyzer;

public class ModelApiAnalyzer
extends BaseApiAnalyzer<ModelElement> {
    private final Map<Type, List<Check>> checksByInterest = new EnumMap<Type, List<Check>>(Type.class);

    public ModelApiAnalyzer() {
        this(ServiceLoader.load(Check.class, ModelApiAnalyzer.class.getClassLoader()));
    }

    ModelApiAnalyzer(Iterable<Check> checks) {
        checks.forEach(c -> c.getInterest().forEach(i -> this.checksByInterest.computeIfAbsent((Type)((Object)((Object)i)), type -> new ArrayList()).add(c)));
    }

    public void initialize(AnalysisContext analysisContext) {
        for (List<Check> checks : this.checksByInterest.values()) {
            checks.forEach(check -> check.initialize(analysisContext));
        }
    }

    public ArchiveAnalyzer<ModelElement> getArchiveAnalyzer(API api) {
        return new ModelArchiveAnalyzer((ApiAnalyzer<ModelElement>)this, api);
    }

    public String getExtensionId() {
        return "flow-connector-analyzer";
    }

    public DifferenceAnalyzer<ModelElement> getDifferenceAnalyzer(ArchiveAnalyzer<ModelElement> oldArchive, ArchiveAnalyzer<ModelElement> newArchive) {
        return new ModelDifferenceAnalyzer(this.checksByInterest);
    }

    public Reader getJSONSchema() {
        return new StringReader("{\n  \"type\": \"object\",\n  \"properties\": {\n    \"connectorName\": {\n      \"type\": \"string\",\n      \"description\": \"The Connector name\"\n    }\n  },\n  \"required\": [\"connectorName\"]\n}\n");
    }
}

