/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer;

import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;

public enum ModelDifference {
    CONNECTOR_NAME_CHANGED("connector.name.changed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    OPERATION_REMOVED("operation.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    INPUT_TYPE_REQUIRED_PROPERTY_ADDED("input.type.required.property.added", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    INPUT_TYPE_UNION_PROPERTY_SAME_ORDER("input.type.union.property.same.order", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, new String[0]);

    private final String code;
    private final EnumMap<CompatibilityType, DifferenceSeverity> classification;
    private final List<String> identifyingAttachments;

    private ModelDifference(String code, DifferenceSeverity sourceSeverity, DifferenceSeverity binarySeverity, DifferenceSeverity semanticSeverity, String ... identifyingAttachments) {
        this.code = code;
        this.classification = new EnumMap(CompatibilityType.class);
        this.classification.put(CompatibilityType.SOURCE, sourceSeverity);
        this.classification.put(CompatibilityType.BINARY, binarySeverity);
        this.classification.put(CompatibilityType.SEMANTIC, semanticSeverity);
        this.identifyingAttachments = List.of(identifyingAttachments);
    }

    public String code() {
        return this.code;
    }

    public Difference createDifference(Map<String, String> attachments, Locale locale) {
        ResourceBundle names = ResourceBundle.getBundle("com.mulesoft.connectivity.flow.api.analyzer.checks.names", locale);
        ResourceBundle descriptions = ResourceBundle.getBundle("com.mulesoft.connectivity.flow.api.analyzer.checks.descriptions", locale);
        Difference.Builder builder = (Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().withCode(this.code)).withName(names.getString(this.code))).withDescription(descriptions.getString(this.code))).addAttachments(attachments)).withIdentifyingAttachments(this.identifyingAttachments);
        for (Map.Entry<CompatibilityType, DifferenceSeverity> e : this.classification.entrySet()) {
            builder.addClassification(e.getKey(), e.getValue());
        }
        return builder.build();
    }
}

