/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer;

import com.mulesoft.connectivity.flow.api.analyzer.element.ConnectorModelElement;
import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import com.mulesoft.connectivity.flow.run.IncompleteConnectorException;
import com.mulesoft.connectivity.flow.run.LoadedConnector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.revapi.API;
import org.revapi.ApiAnalyzer;
import org.revapi.Archive;
import org.revapi.base.BaseArchiveAnalyzer;
import org.revapi.base.BaseElementForest;

class ModelArchiveAnalyzer
extends BaseArchiveAnalyzer<BaseElementForest<ModelElement>, ModelElement> {
    ModelArchiveAnalyzer(ApiAnalyzer<ModelElement> modelApiAnalyzer, API api) {
        super(modelApiAnalyzer, api);
    }

    protected BaseElementForest<ModelElement> newElementForest() {
        return new BaseElementForest(this.getApi());
    }

    protected Stream<ModelElement> discoverRoots(@Nullable Object context) {
        Stream<ModelElement> stream;
        IdentityHashMap<URL, Archive> sources = new IdentityHashMap<URL, Archive>();
        for (Archive archive : this.getApi().getArchives()) {
            try {
                byte[] bytes;
                try (InputStream archiveStream = archive.openStream();){
                    bytes = archiveStream.readAllBytes();
                }
                Path tempFile = this.createTemporaryFileSecurely();
                try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    new ByteArrayInputStream(bytes).transferTo(out);
                }
                sources.put(tempFile.toUri().toURL(), archive);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LoadedConnector loadedConnector = new LoadedConnector(sources.keySet(), new DataWeaveScriptingEngine());
        try {
            stream = Stream.of(new ConnectorModelElement(this.getApi(), (Archive)sources.get(loadedConnector.getMainJar()), loadedConnector.getConnectorModel()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    loadedConnector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IncompleteConnectorException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IOException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        loadedConnector.close();
        return stream;
    }

    protected Stream<ModelElement> discoverElements(@Nullable Object context, ModelElement element) {
        return element.discoverElements().stream();
    }

    private Path createTemporaryFileSecurely() throws IOException {
        Path tempFile;
        block2: {
            try {
                Set<PosixFilePermission> ownerOnly = PosixFilePermissions.fromString("rw-------");
                FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(ownerOnly);
                tempFile = Files.createTempFile("revapi", ".jar", permissions);
            }
            catch (UnsupportedOperationException e) {
                tempFile = Files.createTempFile("revapi", ".jar", new FileAttribute[0]);
                if (tempFile.toFile().setWritable(true, true) && tempFile.toFile().setReadable(true, true)) break block2;
                throw new IOException("Failed to set permissions on temporary file: " + String.valueOf(tempFile));
            }
        }
        tempFile.toFile().deleteOnExit();
        return tempFile;
    }
}

