/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer.check.flow.types;

import com.mulesoft.connectivity.flow.api.analyzer.AttachmentUtils;
import com.mulesoft.connectivity.flow.api.analyzer.ModelDifference;
import com.mulesoft.connectivity.flow.api.analyzer.check.BaseCheck;
import com.mulesoft.connectivity.flow.api.analyzer.check.Type;
import com.mulesoft.connectivity.flow.api.analyzer.element.InputTypeModelElement;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.revapi.Difference;

public class UnionTypeValuesSameOrder
extends BaseCheck {
    @Override
    public EnumSet<Type> getInterest() {
        return EnumSet.of(Type.INPUT_TYPE);
    }

    @Override
    protected void doVisitInputType(@Nullable InputTypeModelElement oldElement, @Nullable InputTypeModelElement newElement) {
        if (oldElement == null || newElement == null) {
            return;
        }
        DWType oldWeaveType = TypeUtils.resolveReferenceType((DWType)((TypeModel)oldElement.getModel()).getDataType());
        DWType newWeaveType = TypeUtils.resolveReferenceType((DWType)((TypeModel)newElement.getModel()).getDataType());
        if (oldWeaveType instanceof ObjectType) {
            ObjectType oldInputType = (ObjectType)oldWeaveType;
            if (newWeaveType instanceof ObjectType) {
                ObjectType newInputType = (ObjectType)newWeaveType;
                if (Arrays.stream(oldInputType.getProperties()).anyMatch(x -> x.getValue() instanceof UnionType) && Arrays.stream(newInputType.getProperties()).anyMatch(y -> y.getValue() instanceof UnionType)) {
                    Arrays.stream(oldInputType.getProperties()).filter(x -> x.getValue() instanceof UnionType).forEach(x -> {
                        UnionType oldUnionType = (UnionType)x.getValue();
                        Arrays.stream(newInputType.getProperties()).filter(y -> y.getKeyName().equals(y.getKeyName())).map(KeyValuePairType::getValue).findFirst().ifPresent(newType -> {
                            if (newType instanceof UnionType) {
                                DWType[] newUnionMembers;
                                UnionType newUnionType = (UnionType)newType;
                                DWType[] oldUnionMembers = oldUnionType.unionOf();
                                if (oldUnionMembers.length == (newUnionMembers = newUnionType.unionOf()).length) {
                                    for (int index = 0; index < oldUnionMembers.length; ++index) {
                                        if (oldUnionMembers[index].equals(newUnionMembers[index])) continue;
                                        this.pushActive(oldElement, newElement);
                                    }
                                }
                            }
                        });
                    });
                }
            }
        }
    }

    @Override
    protected List<Difference> doEnd() {
        BaseCheck.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createDifference(ModelDifference.INPUT_TYPE_UNION_PROPERTY_SAME_ORDER, AttachmentUtils.attachmentsFor(methods.oldElement, methods.newElement, new String[0])));
    }
}

