/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer.check;

import com.mulesoft.connectivity.flow.api.analyzer.ModelDifference;
import com.mulesoft.connectivity.flow.api.analyzer.check.Check;
import com.mulesoft.connectivity.flow.api.analyzer.element.ConnectorModelElement;
import com.mulesoft.connectivity.flow.api.analyzer.element.InputTypeModelElement;
import com.mulesoft.connectivity.flow.api.analyzer.element.ModelElement;
import com.mulesoft.connectivity.flow.api.analyzer.element.OperationModelElement;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Difference;

public abstract class BaseCheck
implements Check {
    private static final String FORCE_OVERRIDE_MESSAGE = "Checks implementation must override the visit methods for the relevant model elements";
    private @Nullable AnalysisContext analysisContext;
    private final Deque<ActiveElements<? extends ModelElement>> activations = new ArrayDeque<ActiveElements<? extends ModelElement>>();
    private int depth;

    protected final <T extends ModelElement> void pushActive(@Nullable T oldElement, @Nullable T newElement) {
        ActiveElements<T> r = new ActiveElements<T>(this.depth, oldElement, newElement);
        this.activations.push(r);
    }

    @Override
    public final List<Difference> visitEnd() {
        try {
            List<Difference> list = this.doEnd();
            return list;
        }
        finally {
            this.popIfActive();
            --this.depth;
        }
    }

    protected abstract List<Difference> doEnd();

    protected <T extends ModelElement> @Nullable ActiveElements<T> popIfActive() {
        return !this.activations.isEmpty() && this.activations.peek().depth == this.depth ? this.activations.pop() : null;
    }

    public @Nullable String getExtensionId() {
        return null;
    }

    public @Nullable Reader getJSONSchema() {
        return null;
    }

    public void initialize(AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    private @Nullable AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    protected Difference createDifference(ModelDifference modelDifference, Map<String, String> attachments) {
        return modelDifference.createDifference(attachments, Objects.requireNonNull(this.getAnalysisContext(), "Initialize method must be called").getLocale());
    }

    @Override
    public final void visit(@Nullable ConnectorModelElement oldElement, @Nullable ConnectorModelElement newElement) {
        ++this.depth;
        this.doVisitConnector(oldElement, newElement);
    }

    protected void doVisitConnector(@Nullable ConnectorModelElement oldElement, @Nullable ConnectorModelElement newElement) {
        throw new IllegalStateException(FORCE_OVERRIDE_MESSAGE);
    }

    @Override
    public final void visit(@Nullable OperationModelElement oldElement, @Nullable OperationModelElement newElement) {
        ++this.depth;
        this.doVisitOperation(oldElement, newElement);
    }

    @Override
    public final void visit(@Nullable InputTypeModelElement oldElement, @Nullable InputTypeModelElement newElement) {
        ++this.depth;
        this.doVisitInputType(oldElement, newElement);
    }

    protected void doVisitOperation(@Nullable OperationModelElement oldElement, @Nullable OperationModelElement newElement) {
        throw new IllegalStateException(FORCE_OVERRIDE_MESSAGE);
    }

    protected void doVisitInputType(@Nullable InputTypeModelElement oldElement, @Nullable InputTypeModelElement newElement) {
        throw new IllegalStateException(FORCE_OVERRIDE_MESSAGE);
    }

    protected static class ActiveElements<T extends ModelElement> {
        public final @Nullable T oldElement;
        public final @Nullable T newElement;
        private final int depth;

        private ActiveElements(int depth, @Nullable T oldElement, @Nullable T newElement) {
            this.depth = depth;
            this.oldElement = oldElement;
            this.newElement = newElement;
        }
    }
}

