/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.analyzer.check.types;

import com.mulesoft.connectivity.flow.api.analyzer.AttachmentUtils;
import com.mulesoft.connectivity.flow.api.analyzer.ModelDifference;
import com.mulesoft.connectivity.flow.api.analyzer.check.BaseCheck;
import com.mulesoft.connectivity.flow.api.analyzer.check.Type;
import com.mulesoft.connectivity.flow.api.analyzer.check.types.TypeCheck;
import com.mulesoft.connectivity.flow.api.analyzer.element.InputTypeModelElement;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.KeyType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.revapi.Difference;

public class InputTypeRequiredPropertyAdded
extends TypeCheck {
    private boolean hasNewRequiredProperties = false;

    @Override
    public EnumSet<Type> getInterest() {
        return EnumSet.of(Type.INPUT_TYPE);
    }

    @Override
    protected void doVisitInputType(@Nullable InputTypeModelElement oldElement, @Nullable InputTypeModelElement newElement) {
        if (oldElement == null || newElement == null) {
            return;
        }
        this.hasNewRequiredProperties = false;
        this.compareTypesRecursive(((TypeModel)oldElement.getModel()).getDataType(), ((TypeModel)newElement.getModel()).getDataType());
        if (this.hasNewRequiredProperties) {
            this.pushActive(oldElement, newElement);
        }
    }

    @Override
    protected void compareObjectTypes(ObjectType oldObjectType, ObjectType newObjectType) {
        Set oldFields = Arrays.stream(oldObjectType.getProperties()).map(f -> ((KeyType)f.getKey()).getName().toString()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        for (KeyValuePairType newProperty : newObjectType.getProperties()) {
            String newFieldName = ((KeyType)newProperty.getKey()).getName().toString();
            if (oldFields.contains(newFieldName) || newProperty.isOptionalKey()) continue;
            this.hasNewRequiredProperties = true;
            return;
        }
        super.compareObjectTypes(oldObjectType, newObjectType);
    }

    @Override
    protected List<Difference> doEnd() {
        BaseCheck.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createDifference(ModelDifference.INPUT_TYPE_REQUIRED_PROPERTY_ADDED, AttachmentUtils.attachmentsFor(methods.oldElement, methods.newElement, new String[0])));
    }
}

