/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderParameterBinding;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.ts.ArrayMetadataValue;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.SimpleReferenceType;
import org.mule.weave.v2.ts.TypeRef;

public class QueryBuilderSupport {
    private final String KIND = "kind";

    public QueryBuilderParameterBinding processParameterAnnotations(KeyValuePairType fieldType) {
        return this.createBinding(fieldType, false);
    }

    public QueryBuilderParameterBinding processPropertyAnnotations(KeyValuePairType fieldType) {
        return this.createBinding(fieldType, true);
    }

    private QueryBuilderParameterBinding createBinding(KeyValuePairType fieldType, boolean isProperty) {
        QueryBuilderParameterBinding queryBuilderParameterBinding = new QueryBuilderParameterBinding();
        queryBuilderParameterBinding.setFieldSelector(this.isAnnotationFieldSelector(fieldType));
        queryBuilderParameterBinding.setOrderBy(this.isQueryBuilderFieldOrderFromAnnotation(fieldType));
        queryBuilderParameterBinding.setFilter(this.isAnnotationResultSetFilter(fieldType));
        queryBuilderParameterBinding.setDiscriminators(isProperty ? this.makePropertyDiscriminator(fieldType) : this.makeParameterDiscriminator(fieldType));
        return queryBuilderParameterBinding;
    }

    public boolean isAnnotationResultSetFilter(KeyValuePairType fieldType) {
        if (fieldType == null || fieldType.getValue() == null) {
            return false;
        }
        return Stream.of(fieldType.getValue().getTypeMetadata()).anyMatch(metadata -> metadata.getName().equalsIgnoreCase(FlowMetadataKey.RESULT_SET_FILTER.getKey()));
    }

    public boolean isQueryBuilderFieldOrderFromAnnotation(KeyValuePairType fieldType) {
        if (fieldType == null || fieldType.getValue() == null) {
            return false;
        }
        return FlowMetadataUtils.isFieldOrder((DWType)fieldType);
    }

    public boolean isAnnotationFieldSelector(KeyValuePairType fieldType) {
        if (fieldType == null || fieldType.getValue() == null) {
            return false;
        }
        return FlowMetadataUtils.isFieldSelector((DWType)fieldType);
    }

    List<String> makePropertyDiscriminator(KeyValuePairType fieldType) {
        if (fieldType == null || fieldType.getValue() == null) {
            return null;
        }
        return Arrays.stream(fieldType.getValue().getTypeMetadata()).filter(k -> k.getName().equalsIgnoreCase("discriminators")).map(DWMetadata::getValue).map(c -> (ArrayMetadataValue)c).flatMap(v -> Arrays.stream(v.getElements())).map(v -> (LiteralMetadataValue)v).map(LiteralMetadataValue::getValue).collect(Collectors.toList());
    }

    List<String> makeParameterDiscriminator(KeyValuePairType fieldType) {
        if (!this.isAnnotationFieldSelector(fieldType) && !this.isAnnotationResultSetFilter(fieldType)) {
            return List.of();
        }
        if (fieldType.getValue() instanceof UnionType) {
            return this.makeMetadataDiscriminator(fieldType.getValue());
        }
        if (fieldType.getValue() instanceof SimpleReferenceType) {
            return this.makeMetadataDiscriminator((DWType)((SimpleReferenceType)fieldType.getValue()).typeRef().ref());
        }
        return List.of();
    }

    private List<String> makeMetadataDiscriminator(DWType unionType) {
        return Optional.of(unionType).filter(value -> value instanceof UnionType).map(value -> (UnionType)value).map(UnionType::unionOf).stream().flatMap(Arrays::stream).map(c -> (SimpleReferenceType)c).map(SimpleReferenceType::typeRef).map(TypeRef::ref).map(o -> ((ObjectType)o).getProperties()).flatMap(properties -> Arrays.stream(properties).filter(k -> "kind".equalsIgnoreCase(k.getKeyName())).map(kv -> kv.getValue().toString())).collect(Collectors.toList());
    }
}

