/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.run;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.google.gson.Gson;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorDescriptorModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.run.IncompleteConnectorException;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadedConnector
implements Closeable {
    final DataWeaveScriptingEngine dataWeaveEngine;
    private final FlowConnectorDescriptorModel connectorDescriptorModel;
    private final URLClassLoader connectorClassLoader;
    private final FlowConnectorModel connectorModel;
    private final URL mainJar;
    final ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadedConnector.class);
    private @Nullable List<Icon> icons;

    public LoadedConnector(Collection<URL> urls, DataWeaveScriptingEngine dataWeaveEngine) throws IOException, InvocationTargetException, IncompleteConnectorException {
        this.dataWeaveEngine = dataWeaveEngine;
        FlowConnectorDescriptorModel dm = null;
        URL j = null;
        for (URL url : urls) {
            JarFile jarFile = LoadedConnector.getJarFile(url);
            dm = LoadedConnector.getFlowConnectorDescriptorModel(jarFile).orElse(null);
            if (dm == null) continue;
            j = url;
            break;
        }
        if (dm == null) {
            throw new IncompleteConnectorException("Failed to find flow-connector.ic file in all sources.");
        }
        this.mainJar = j;
        this.connectorDescriptorModel = dm;
        this.connectorClassLoader = URLClassLoader.newInstance((URL[])urls.toArray(URL[]::new), this.originalContextClassLoader);
        try {
            FlowConnectorLoader.ExtraData extraData = new FlowConnectorLoader.ExtraData(this.connectorDescriptorModel.getVersion(), this.connectorDescriptorModel.getReleaseStatus(), this.connectorDescriptorModel.getSince());
            this.connectorModel = this.runInConnectorClassLoader(() -> (FlowConnectorModel)new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement")).loadConnector(this.connectorDescriptorModel.getModelReference(), (Object)extraData));
        }
        catch (Exception e) {
            Exception c2 = e;
            for (Throwable c1 = e; c1 != null; c1 = c1.getCause()) {
                c2 = c1;
            }
            if (c2 instanceof CompilationException && (c2.getMessage().contains("Unable to resolve module with identifier") || c2.getMessage().contains("Unable to resolve reference of:"))) {
                throw new IncompleteConnectorException("Failed to find all connector elements in the given sources.");
            }
            throw new InvocationTargetException(e);
        }
    }

    static Optional<FlowConnectorDescriptorModel> getFlowConnectorDescriptorModel(JarFile jarFile) throws IOException {
        JarEntry jarEntry = jarFile.getJarEntry("META-INF/flow-connector.ic");
        if (jarEntry == null) {
            return Optional.empty();
        }
        return Optional.of((FlowConnectorDescriptorModel)new Gson().fromJson((Reader)new InputStreamReader(jarFile.getInputStream(jarEntry), StandardCharsets.UTF_8), FlowConnectorDescriptorModel.class));
    }

    private static JarFile getJarFile(URL url) throws IOException {
        if (!url.getProtocol().equalsIgnoreCase("jar")) {
            url = new URL("jar:" + String.valueOf(url) + "!/");
        }
        return ((JarURLConnection)url.openConnection()).getJarFile();
    }

    public FlowConnectorModel getConnectorModel() {
        return this.connectorModel;
    }

    public FlowConnectorDescriptorModel getConnectorDescriptorModel() {
        return this.connectorDescriptorModel;
    }

    public List<Icon> getIcons() {
        try {
            if (this.icons != null) {
                return this.icons;
            }
            this.icons = this.runInConnectorClassLoader(() -> this.connectorDescriptorModel.getIcons().stream().map(this::getIconResource).map(this::loadIcon).filter(Objects::nonNull).toList());
            return this.icons;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private @Nullable ImageIcon loadIcon(String resource) {
        if (resource.endsWith(".svg")) {
            return new FlatSVGIcon(resource, 32, 32, (ClassLoader)this.connectorClassLoader);
        }
        if (resource.endsWith(".png")) {
            URL url = this.connectorClassLoader.getResource(resource);
            if (url == null) {
                LOGGER.warn("Can't find resource {}", (Object)resource);
                return null;
            }
            return new ImageIcon(url);
        }
        LOGGER.warn("Icon with unknown format {}", (Object)resource);
        return null;
    }

    private String getIconResource(IconMetadata iconMetadata) {
        String modelReference = this.connectorDescriptorModel.getModelReference();
        if (modelReference.startsWith("com::mulesoft::connectivity::")) {
            String name = this.connectorDescriptorModel.getModelReference().replaceAll("com::mulesoft::connectivity::(.*)::[^:]+::[^:]+", "$1").replaceAll("::", "/");
            return "com/mulesoft/connectivity/" + name + "/" + iconMetadata.getResource();
        }
        return iconMetadata.getResource();
    }

    public URL getMainJar() {
        return this.mainJar;
    }

    public ModelInterpreter createInterpreter() {
        ModelInterpreterConfig config = new ModelInterpreterConfig.Builder().build();
        return new ModelInterpreter(this.dataWeaveEngine, config);
    }

    public <T> T runInConnectorClassLoader(Callable<? extends T> code) throws Exception {
        Thread.currentThread().setContextClassLoader(this.connectorClassLoader);
        try {
            T t = code.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalContextClassLoader);
        }
    }

    @Override
    public void close() throws IOException {
        this.connectorClassLoader.close();
    }
}

