/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class FlowObjectRule
extends Rule<ObjectType> {
    public FlowObjectRule() {
        super(ObjectType.class);
    }

    protected void validate(Validatable<ObjectType> validatable, ValidationContext ctx) {
        ObjectType type = (ObjectType)validatable.getElement();
        if (type.getProperties().length == 0 && MetadataUtils.getMetadataProvider((DWType)type).isEmpty() && !this.isTopObject(validatable)) {
            ctx.addWarning(type.getLocation(), "Object type must have at least one property or have a Metadata Provider", "InvalidFlowType");
        }
    }

    private boolean isTopObject(Validatable<ObjectType> validatable) {
        Set types = validatable.getParent().getTypes();
        return types.contains(ValidatableType.INPUT) || types.contains(ValidatableType.OUTPUT);
    }

    public boolean appliesTo(Validatable<ObjectType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }
}

