/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;

public class TemplateRule
extends Rule<StringType> {
    public TemplateRule() {
        super(StringType.class);
    }

    public boolean appliesTo(Validatable<StringType> validatable) {
        return super.appliesTo(validatable) && Arrays.stream(((StringType)validatable.getElement()).getTypeMetadata()).anyMatch(m -> MetadataKey.TEMPLATE.getKey().equals(m.getName()));
    }

    protected void validate(Validatable<StringType> validatable, ValidationContext ctx) {
        Object object;
        StringType type = (StringType)validatable.getElement();
        if (validatable.getParent() != null && (object = validatable.getParent().getElement()) instanceof ObjectType) {
            ObjectType parentObjectType = (ObjectType)object;
            String template = (String)MetadataUtils.getTemplate((DWType)type).get();
            List<String> placeholders = this.extractPlaceholders(template);
            for (String placeHolder : placeholders) {
                if (!Arrays.stream(parentObjectType.getProperties()).noneMatch(p -> placeHolder.equals(p.getKeyName()))) continue;
                ctx.addError(validatable.getLocation(), "Field for placeholder: '" + placeHolder + "' not found in Object", "InvalidFlowType");
            }
        }
    }

    private List<String> extractPlaceholders(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{\\{(.*?)}}");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }
}

