/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256;

import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.ServiceModelLoader;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.ComponentPath;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class ObjectOrNullReferenceServiceLoader
implements ServiceModelLoader {
    private final ServiceModelLoader delegate;
    private final Map<TypeService, ComponentPath> describeAsAnonymousTypes = ObjectOrNullReferenceServiceLoader.getAnonymousObjects();
    private final Set<String> services = Set.of("Openai", "Qualtrics", "Intercom");

    public ObjectOrNullReferenceServiceLoader(ServiceModelLoader serviceModelLoader) {
        this.delegate = serviceModelLoader;
    }

    @Override
    public ServiceModel loadServiceModel(FlowConnectorModel model) {
        ServiceModel serviceModel = this.delegate.loadServiceModel(model);
        if (!this.services.contains(model.getDeveloperName())) {
            return serviceModel;
        }
        List<Component> components = serviceModel.getComponents();
        Map<String, List<Component>> graph = this.createAdjacencyList(components);
        serviceModel.getComponents().stream().filter(component -> ComponentType.OBJECT.equals((Object)component.getComponentType())).filter(component -> this.describeAsAnonymousTypes.containsKey(new TypeService(component.getName(), model.getDeveloperName()))).sorted((a, b) -> {
            if ("T_team_priority_level".equals(a.getName())) {
                return 1;
            }
            if ("T_team_priority_level".equals(b.getName())) {
                return -1;
            }
            return 0;
        }).forEach(component -> {
            ComponentPath componentPath = this.describeAsAnonymousTypes.get(new TypeService(component.getName(), model.getDeveloperName()));
            Component parentElement = this.getElementInPath(components, componentPath, graph);
            ((List)graph.get(component.getOuter())).remove(component);
            graph.computeIfAbsent(parentElement.getId(), k -> new ArrayList()).add(component);
            component.setOuter(parentElement.getId());
            component.setName("");
        });
        return serviceModel;
    }

    private Component getElementInPath(Collection<Component> elements, ComponentPath path, Map<String, List<Component>> adjacencyList) {
        return elements.stream().filter(component -> this.matchesComponent((Component)component, path)).findFirst().map(component -> this.getNextOuter((Component)component, path, adjacencyList)).orElseThrow(() -> new RuntimeException("Could not find component: " + String.valueOf(path)));
    }

    private boolean matchesComponent(Component component, ComponentPath location) {
        ComponentType componentType = location.getComponentType();
        String name = location.getName();
        return componentType.equals((Object)component.getComponentType()) && (name == null || name.equals(component.getName()));
    }

    private Component getNextOuter(Component component, ComponentPath location, Map<String, List<Component>> adjacencyList) {
        if (location.getNext() == null) {
            return component;
        }
        List<Component> children = adjacencyList.get(component.getId());
        return this.getElementInPath(children, location.getNext(), adjacencyList);
    }

    private Map<String, List<Component>> createAdjacencyList(Collection<Component> components) {
        HashMap<String, List<Component>> adjacencyList = new HashMap<String, List<Component>>();
        components.forEach(component -> {
            if (component.getOuter() != null) {
                adjacencyList.computeIfAbsent(component.getOuter(), k -> new ArrayList()).add(component);
            }
        });
        return adjacencyList;
    }

    private static Map<TypeService, ComponentPath> getAnonymousObjects() {
        HashMap<TypeService, ComponentPath> componentPaths = new HashMap<TypeService, ComponentPath>();
        componentPaths.put(new TypeService("T_contact_tags", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/CreateContact#OPERATION/OUT_PARAMETER/OBJECT/tags#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_update_company_request", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/UpdateCompany#OPERATION/update_company_request#IN_PARAMETER"));
        componentPaths.put(new TypeService("T_customer_request", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/T_attach_contact_to_conversation_request#OBJECT/customer#PROPERTY_TYPE/OBJECT/customer#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_conversation_rating", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/AttachContactToConversation#OPERATION/OUT_PARAMETER/OBJECT/conversation_rating#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_conversation_teammates", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/AttachContactToConversation#OPERATION/OUT_PARAMETER/OBJECT/teammates#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_conversation_first_contact_reply", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/AttachContactToConversation#OPERATION/OUT_PARAMETER/OBJECT/first_contact_reply#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_sla_applied", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/AttachContactToConversation#OPERATION/OUT_PARAMETER/OBJECT/sla_applied#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_conversation_statistics", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/AttachContactToConversation#OPERATION/OUT_PARAMETER/OBJECT/statistics#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_admin", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/CreateNote#OPERATION/OUT_PARAMETER/OBJECT/author#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_team_priority_level", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/CreateNote#OPERATION/OUT_PARAMETER/OBJECT/author#PROPERTY_TYPE/OBJECT/team_priority_level#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_create_or_update_company_request", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/CreateOrUpdateCompany#OPERATION/create_or_update_company_request#IN_PARAMETER"));
        componentPaths.put(new TypeService("T_ticket_type_attribute", "Intercom"), ComponentPath.fromTopDown("Intercom#SERVICE/T_ticket_type_attribute_list#OBJECT/ticket_type_attributes#PROPERTY_TYPE/ARRAY"));
        componentPaths.put(new TypeService("T_RunCompletionUsage", "Openai"), ComponentPath.fromTopDown("Openai#SERVICE/CreateThreadAndRun#OPERATION/OUT_PARAMETER/OBJECT/usage#PROPERTY_TYPE"));
        componentPaths.put(new TypeService("T_DeduplicationCriteria", "Qualtrics"), ComponentPath.fromTopDown("Qualtrics#SERVICE/T_SingleDirectory#OBJECT/deduplicationCriteria#PROPERTY_TYPE"));
        return componentPaths;
    }

    private record TypeService(String typeName, String serviceName) {
        @Generated
        public String getTypeName() {
            return this.typeName;
        }
    }
}

