/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.HashSet;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;

public class FlowConnectionsRule
extends Rule<ObjectType> {
    public FlowConnectionsRule() {
        super(ObjectType.class, ValidatableType.CONNECTOR);
    }

    protected void validate(Validatable<ObjectType> validatable, ValidationContext ctx) {
        Optional connectionsProperty = TypeUtils.getObjectProperty((DWType)((DWType)validatable.getElement()), (String)"connections");
        if (connectionsProperty.isEmpty()) {
            return;
        }
        DWType dWType = ((KeyValuePairType)connectionsProperty.get()).getValue();
        if (!(dWType instanceof ObjectType)) {
            ctx.addError(((KeyValuePairType)connectionsProperty.get()).getLocation(), "Invalid type for property 'connections'. Expected: Object; Actual: " + ((KeyValuePairType)connectionsProperty.get()).getValue().toString(), "connector");
            return;
        }
        ObjectType connectionsObject = (ObjectType)dWType;
        HashSet<String> seenAuthTypes = new HashSet<String>();
        for (KeyValuePairType connectionEntry : connectionsObject.getProperties()) {
            StringType stringType;
            Object t;
            ObjectType authObj;
            Optional typeProp;
            DWType dWType2;
            String authenticationType = null;
            Optional authenticationTypeProp = TypeUtils.getObjectPropertyType((DWType)connectionEntry.getValue(), (String)"authenticationType");
            if (authenticationTypeProp.isPresent() && (dWType2 = TypeUtils.resolveReferenceType((DWType)((DWType)authenticationTypeProp.get()))) instanceof ObjectType && (typeProp = TypeUtils.getObjectPropertyType((DWType)(authObj = (ObjectType)dWType2), (String)"type")).isPresent() && (t = typeProp.get()) instanceof StringType && (stringType = (StringType)t).getValue().isPresent()) {
                authenticationType = (String)stringType.getValue().get();
            }
            if (authenticationType == null || seenAuthTypes.add(authenticationType)) continue;
            ctx.addError(((KeyValuePairType)connectionsProperty.get()).getLocation(), "Property 'connections' contains multiple connections with the same authenticationType: " + authenticationType, "connector");
            return;
        }
        for (KeyValuePairType keyValuePairType : connectionsObject.getProperties()) {
            DWType weaveType = TypeUtils.resolveReferenceType((DWType)keyValuePairType.getValue());
            ctx.queue(ctx.validatable((Object)weaveType).withType(ValidatableType.CONNECTION).withName(keyValuePairType.getKeyName()).build());
        }
    }
}

