/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FlowIconRule
extends Rule<DWType> {
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";

    public FlowIconRule() {
        super(DWType.class, ValidatableType.CONNECTOR);
    }

    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        ObjectType connector = (ObjectType)validatable.getElement();
        Optional maybeIconsProperty = DWTypeUtils.getFieldByName((ObjectType)connector, (String)"icons");
        if (maybeIconsProperty.isEmpty()) {
            ctx.addError(connector.getLocation(), "Icon Property is empty. Expected: Icon Property to be present. Actual: Icon Property is Empty", "connector");
            return;
        }
        KeyValuePairType iconsProperty = (KeyValuePairType)maybeIconsProperty.get();
        DWType iconsObjectType = ((ArrayType)iconsProperty.getValue()).arrayOf();
        Optional maybeResourceName = TypeUtils.getObjectProperty((DWType)iconsObjectType, (String)"resource").map(KeyValuePairType::getValue).map(StringType.class::cast).flatMap(StringType::getValue);
        if (maybeResourceName.isEmpty()) {
            ctx.addError(iconsProperty.getLocation(), "The 'resource' property is not present in the icon definition.", "connector");
            return;
        }
        String resourceName = (String)maybeResourceName.get();
        if (!resourceName.endsWith(".svg")) {
            ctx.addError(iconsProperty.getLocation(), "Invalid name for icon. Expected: Ending with .svg; Actual: " + resourceName, "connector");
            return;
        }
        if (resourceName.contains(" ")) {
            ctx.addError(iconsProperty.getLocation(), "Icon resource name should not have space. Expected: Resource Name of icon without space; Actual: " + resourceName, "connector");
            return;
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            ctx.addWarning(iconsProperty.getLocation(), "Couldn't find icon file '" + resourceName + "'", "connector");
            return;
        }
        this.validateIcon(url, iconsProperty.getLocation(), ctx);
    }

    private void validateIcon(URL url, Location location, ValidationContext ctx) {
        Document doc = null;
        try (InputStream in = url.openStream();){
            byte[] data = in.readAllBytes();
            if (data.length == 0) {
                ctx.addError(location, "Icon file is empty. It should contain icon data in svg format.", "connector");
                return;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbFactory.setNamespaceAware(true);
            DocumentBuilder db = dbFactory.newDocumentBuilder();
            doc = db.parse(new ByteArrayInputStream(data));
        }
        catch (IOException e2) {
            ctx.addError(location, "Could not read icon file. Please check file permissions and try again: '" + url.getPath() + ". Error: " + e2.getMessage(), "connector");
        }
        catch (ParserConfigurationException e3) {
            throw new RuntimeException(e3);
        }
        catch (SAXException e4) {
            ctx.addError(location, "Could not parse SVG icon. Make sure the SVG is not corrupted and try again: '" + url.getPath() + ". Error: " + e4.getMessage(), "connector");
        }
        XPathFactory xPathFactory = XPathFactory.newDefaultInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "svg".equals(prefix) ? FlowIconRule.SVG_NAMESPACE : "";
            }

            @Override
            public @Nullable String getPrefix(String namespaceURI) {
                return namespaceURI.equals(FlowIconRule.SVG_NAMESPACE) ? "svg" : null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return List.of("svg").iterator();
            }
        });
        List<Map.Entry<String, String>> validations = List.of(Map.entry("namespace-uri(/svg:svg) = 'http://www.w3.org/2000/svg'", "Must have an 'xmlns' attribute with the proper namespace"), Map.entry("/svg:svg[@id = 'icon']", "Must have an 'id' attribute with value 'icon'"), Map.entry("count(//svg:path/@fill) = count(//svg:path)", "Every path element in the SVG icon must have a 'fill' attribute"), Map.entry("count(//svg:clipPath) = 0", "SVG icons must not have 'clipPath' elements"), Map.entry("not(contains(/svg:svg/@width, 'px')) and not(contains(/svg:svg/@height, 'px'))", "SVG must not have 'width' or 'height' attributes with 'px' values"));
        Document finalDoc = doc;
        validations.stream().filter(e -> {
            try {
                return xPath.evaluateExpression((String)e.getKey(), finalDoc, Boolean.class) == false;
            }
            catch (XPathExpressionException ex) {
                throw new RuntimeException(ex);
            }
        }).forEach(e -> ctx.addError(location, (String)e.getValue(), "connector"));
    }
}

