/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.weave.v2.api.tooling.ts.AnyType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationManager;
import org.mule.weave.v2.ts.TypeHelper;
import org.mule.weave.v2.ts.WeaveType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

class UnionTypeHandler
extends TypeHandler {
    UnionTypeHandler(ComponentRegistry componentRegistry) {
        super(componentRegistry);
    }

    @Override
    public boolean handles(DWType type) {
        return type instanceof UnionType;
    }

    @Override
    public String getTypeName() {
        return "UnionType";
    }

    @Override
    public Component make(DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        if (!(dwType instanceof UnionType)) {
            throw new AssertionError();
        }
        List<DWType> of = Arrays.stream(this.unionElements(dwType)).filter(e -> !(e instanceof NullType)).filter(e -> !(e instanceof AnyType)).toList();
        if (of.isEmpty()) {
            return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("Any")).build();
        }
        DWType headType = of.get(0);
        boolean heterogeneous = of.stream().anyMatch(a -> !a.getClass().equals(headType.getClass()));
        if (heterogeneous) {
            System.err.println("Error: Not Heterogeneous Union: please check type: " + typeName + " in service: " + this.componentRegistry.getServiceComponent().getName());
            return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("Any")).build();
        }
        if (headType instanceof StringType || headType instanceof BooleanType || headType instanceof NumberType) {
            return typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
        }
        TypeHelper helper = new TypeHelper(new ParsingNotificationManager());
        Seq seq = JavaConverters.collectionAsScalaIterable((Collection)of.stream().map(a -> (WeaveType)a).collect(Collectors.toList())).toSeq();
        WeaveType resolvedUnion = helper.resolveUnion(helper.unify(seq));
        if (resolvedUnion instanceof UnionType) {
            throw new RuntimeException("Error: Not Able to simplify Union: `" + String.valueOf(dwType) + "` please check type: " + typeName + " in service: " + this.componentRegistry.getServiceComponent().getName());
        }
        return typeFactory.make((DWType)resolvedUnion, typeName, outer);
    }

    private DWType[] unionElements(DWType type) {
        DWType[] of;
        if (type instanceof UnionType) {
            UnionType union = (UnionType)type;
            of = (DWType[])Arrays.stream(union.unionOf()).flatMap(e -> Arrays.stream(this.unionElements((DWType)e))).toArray(DWType[]::new);
        } else {
            if (type instanceof ReferenceType) {
                return this.unionElements(TypeUtils.resolveReferenceType((DWType)type));
            }
            of = new DWType[]{type};
        }
        return of;
    }
}

