/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import java.util.Map;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NumberType;

class NumberTypeHandler
extends TypeHandler {
    private static final Map<String, String> PRECISION_MAPPING = Map.of("int64", "Long", "integer", "Long", "int32", "Integer", "float", "Float", "double", "Double");

    NumberTypeHandler(ComponentRegistry componentRegistry) {
        super(componentRegistry);
    }

    @Override
    public boolean handles(DWType type) {
        return type instanceof NumberType;
    }

    @Override
    public String getTypeName() {
        return "Number";
    }

    @Override
    public Component make(DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        assert (dwType instanceof NumberType);
        Optional formatAnnotation = MetadataUtils.getFormat((DWType)dwType);
        return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name(formatAnnotation.map(PRECISION_MAPPING::get).orElse(PRECISION_MAPPING.get("double")))).outer(this.componentRegistry.getServiceComponent().getId())).build();
    }
}

