/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.validator.rules.ValidatorUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.EnumSet;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class UnsupportedTypeRule
extends Rule<DWType> {
    public UnsupportedTypeRule() {
        super(DWType.class, EnumSet.noneOf(ValidatableType.class));
    }

    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        DWType type = (DWType)validatable.getElement();
        if (ValidatorUtils.isSupportedSimpleType(type) || type instanceof ObjectType || type instanceof ArrayType || type instanceof UnionType || type instanceof ReferenceType || type instanceof IntersectionType) {
            return;
        }
        if (validatable.getParent() != null && validatable.getParent().hasType(ValidatableType.OUTPUT) && type instanceof NullType) {
            return;
        }
        String path = validatable.stringPath();
        ctx.addError(validatable.getLocation(), "Unsupported type" + (String)(path.isEmpty() ? "" : " at " + path) + ": " + String.valueOf(type), "InvalidFlowType");
    }

    public boolean appliesTo(Validatable<DWType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }
}

