/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.run;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.http.service.metadata.ObjectMetadataValue;

public class InterceptedHttpClientResponse
implements HttpClientResponse {
    private final HttpClientResponse original;
    private final Consumer<byte[]> bodyReceived;

    public InterceptedHttpClientResponse(HttpClientResponse original, Consumer<byte[]> bodyReceived) {
        this.original = original;
        this.bodyReceived = bodyReceived;
    }

    public int getStatus() {
        return this.original.getStatus();
    }

    public Optional<String> getStatusText() {
        return this.original.getStatusText();
    }

    public HttpClientHeaders getHeaders() {
        return this.original.getHeaders();
    }

    public Optional<String> getContentType() {
        return this.original.getContentType();
    }

    public Optional<InputStream> getBody() {
        return this.original.getBody().map(stream -> new FilterInputStream((InputStream)stream){
            private final ByteArrayOutputStream bos;
            {
                this.bos = new ByteArrayOutputStream();
            }

            @Override
            public int read() throws IOException {
                int ch = super.read();
                if (ch == -1) {
                    InterceptedHttpClientResponse.this.bodyReceived.accept(this.bos.toByteArray());
                } else {
                    this.bos.write(ch);
                }
                return ch;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int n = super.read(b, off, len);
                if (n == -1) {
                    InterceptedHttpClientResponse.this.bodyReceived.accept(this.bos.toByteArray());
                } else {
                    this.bos.write(b, off, n);
                }
                return n;
            }
        });
    }

    public Optional<ObjectMetadataValue> getMetadata() {
        return this.original.getMetadata();
    }

    public Optional<String> getLocation() {
        return this.original.getLocation();
    }

    public List<HttpCookie> getCookies() {
        return this.original.getCookies();
    }
}

