/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.validation.ProviderType;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectMetadataValue;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.VariableReferenceMetadataValue;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;
import org.mule.weave.v2.ts.TypeType;
import org.mule.weave.v2.ts.WeaveType;

public class RequiresValueProviderAnnotationRule
extends Rule<DWType> {
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = DataWeaveScriptingEngine.apply((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());

    public RequiresValueProviderAnnotationRule() {
        super(DWType.class);
    }

    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        DWType type = (DWType)validatable.getElement();
        Arrays.stream(type.getTypeMetadata()).filter(typeMetadata -> typeMetadata.getName().equals("requiresValueProvider")).findFirst().ifPresent(typeMetadata -> this.validateRequiresValueProvider(validatable.getLocation(), ctx, type, validatable.stringPath(), (DWMetadata)typeMetadata));
    }

    private void validateRequiresValueProvider(Location location, ValidationContext ctx, DWType type, String path, DWMetadata requiresValueProvider) {
        Optional maybeProviderReference = MetadataUtils.getValueProvider((DWType)type);
        if (maybeProviderReference.isEmpty()) {
            ctx.addError(location, "Property" + (String)(path.isEmpty() ? "" : " at " + path) + " requires a value provider but none was defined.", "InvalidFlowType");
            return;
        }
        SimpleReferenceType valueProvider = (SimpleReferenceType)ctx.getProvider(ProviderType.VALUE_PROVIDER, ((ProviderReference)maybeProviderReference.get()).getName());
        if (valueProvider != null) {
            MessageCollector tempMessageCollector = new MessageCollector();
            DWMetadataValue dWMetadataValue = requiresValueProvider.getValue();
            if (dWMetadataValue instanceof ObjectMetadataValue) {
                ObjectMetadataValue value = (ObjectMetadataValue)dWMetadataValue;
                valueProvider.getTypeParameters().ifPresent(typeParameters -> {
                    this.checkType(location, ctx, path, value, tempMessageCollector, "providedValueType", typeParameters[2], "value");
                    this.checkType(location, ctx, path, value, tempMessageCollector, "displayPropertiesType", typeParameters[3], "display properties");
                });
            }
        }
    }

    private void checkType(Location location, ValidationContext ctx, String path, ObjectMetadataValue requiresValueProvider, MessageCollector tempMessageCollector, String annotationParamName, DWType actualType, String what) {
        String requiredTypeFqn = RequiresValueProviderAnnotationRule.getAnnotationTypeParameter(requiresValueProvider, annotationParamName);
        if (requiredTypeFqn == null) {
            return;
        }
        if (!ctx.getTypeHelper().canBeAssignedTo((WeaveType)actualType, ((TypeType)this.dataWeaveScriptingEngine.inferTypeOf(requiredTypeFqn).get()).getType(), null, false, tempMessageCollector)) {
            ctx.addError(location, "Invalid value provider" + (String)(path.isEmpty() ? "" : " at " + path) + " required " + what + " type is " + requiredTypeFqn + " but received " + String.valueOf(actualType), "InvalidFlowType");
        }
    }

    private static @Nullable String getAnnotationTypeParameter(ObjectMetadataValue requiresValueProvider, String name) {
        return Arrays.stream(requiresValueProvider.getProperties()).filter(kv -> kv.getKey().equals(name)).findFirst().map(kv -> (VariableReferenceMetadataValue)kv.getValue()).map(VariableReferenceMetadataValue::getFullyQualifiedName).orElse(null);
    }

    public boolean appliesTo(Validatable<DWType> validatable) {
        return super.appliesTo(validatable) && validatable.hasContext(ValidatableType.OPERATION) && validatable.hasContext(ValidatableType.INPUT);
    }
}

