/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderSupport;
import com.mulesoft.connectivity.linkweave.api.loader.ContextVariablesResolver;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.parser.location.SimpleParserPosition;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.ts.ArrayMetadataValue;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.KeyType;
import org.mule.weave.v2.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.Metadata;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.NameType;
import org.mule.weave.v2.ts.NameValuePairType;
import org.mule.weave.v2.ts.ObjectMetadataValue;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.SimpleReferenceType;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.TypeRef;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;

public class QueryBuilderAdapter {
    static final String OBJECT_TYPE_FIELD = "objectType";
    static final String PROJECTED_FIELDS_FIELD = "projectedFields";
    static final String FILTER_FIELD = "filter";
    static final String ORDER_BY_FIELD = "orderBy";
    static final String CONDITIONS_FIELD = "conditions";
    static final String FIELD_NAME_FIELD = "field";
    static final String OPERATOR_FIELD = "operator";
    static final String KIND_FIELD = "kind";
    static final String FIELDS_FIELD = "fields";
    static final String EXPRESSION_FIELD = "expression";
    static final String VALUE_FIELD = "value";
    static final String VALUES_FIELD = "values";
    static final String OBJECT_TYPE_PATH = "/objectType";
    static final String VALUE_PROVIDER = "valueProvider";
    static final String NAME = "name";
    public static final String DISCRIMINATORS = "discriminators";
    static final String ARGUMENTS = "arguments";
    static final String FIELDS_VP = "fieldsValueProvider";
    static final String PROJECTED_DISCRIMINATORS_VP = "projectedDiscriminatorsValueProvider";
    static final String FILTER_DISCRIMINATORS_VP = "filterDiscriminatorsValueProvider";
    static final String OPERATORS_VP = "operatorsValueProvider";
    static final String PROJECTED_FIELDS_APEX_CLASS = "ProjectedFieldsType";
    static final String FILTER_APEX_CLASS = "QueryResultSetFilter";
    static final String CONDITION_APEX_CLASS = "QueryFilterCondition";
    static final String FIELD_ORDER_PAIR_APEX_CLASS = "QueryFieldOrderPair";
    static final String FIELD_PROPERTY_NAME = "field";
    static final String ORDER_PROPERTY_NAME = "order";
    static final String NO_ORDER_TYPE = "QueryFieldNoOrder";
    static final String NO_ORDER_TYPE_FULL_NAME = "com_mulesoft_connectivity_flow_QueryBuilder_QueryFieldNoOrder";
    static final String SINGLE_FIELD_ORDER_TYPE = "QuerySingleFieldOrder";
    static final String SINGLE_FIELD_ORDER_TYPE_FULL_NAME = "com_mulesoft_connectivity_flow_QueryBuilder_QuerySingleFieldOrder";
    static final String MANY_FIELDS_SINGLE_ORDER_TYPE = "QueryManyFieldsSingleSortingOrder";
    static final String MANY_FIELDS_SINGLE_ORDER_TYPE_FULL_NAME = "com_mulesoft_connectivity_flow_QueryBuilder_QueryManyFieldsSingleSortingOrder";
    static final String MANY_FIELDS_MANY_ORDER_TYPE = "QueryManyFieldsManySortingOrder";
    static final String MANY_FIELDS_MANY_ORDER_TYPE_FULL_NAME = "com_mulesoft_connectivity_flow_QueryBuilder_QueryManyFieldsManySortingOrder";
    static final WeaveType STRING_TYPE = new StringType(Option.empty());
    static final ListBuffer<NameValuePairType> EMPTY_LIST = new ListBuffer();
    static final ArrayType STRING_ARRAY_TYPE = new ArrayType(STRING_TYPE);
    static final Position START_POSITION = new SimpleParserPosition(2362, 49, 40, null);
    static final Position END_POSITION = new SimpleParserPosition(2362, 49, 100, null);
    static final WeaveLocation WEAVE_LOCATION = new WeaveLocation(START_POSITION, END_POSITION, NameIdentifier.ANONYMOUS_NAME());
    private static final QueryBuilderSupport QUERY_BUILDER_SUPPORT = new QueryBuilderSupport();

    private QueryBuilderAdapter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static OperationModel adapt(OperationModel inputOperationModel) {
        if (FlowMetadataUtils.isQueryBuilder((DWType)inputOperationModel.getInputType().getDataType())) {
            return QueryBuilderAdapter.transformOperationModel(inputOperationModel);
        }
        return inputOperationModel;
    }

    public static TriggerModel adapt(TriggerModel inputTriggerModel) {
        if (FlowMetadataUtils.isQueryBuilder((DWType)inputTriggerModel.getInputType().getDataType())) {
            return QueryBuilderAdapter.transformTriggerModel(inputTriggerModel);
        }
        return inputTriggerModel;
    }

    static OperationModel transformOperationModel(OperationModel input) {
        DWType dwType = input.getInputType().getDataType();
        if ((dwType = TypeUtils.resolveReferenceType((DWType)dwType)) instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dwType;
            OperationModel.Builder builder = OperationModel.builder();
            QueryBuilderAdapter.configureBuilder(input, objectType, builder);
            return (OperationModel)builder.build();
        }
        return input;
    }

    static TriggerModel transformTriggerModel(TriggerModel input) {
        DWType dwType = input.getInputType().getDataType();
        if ((dwType = TypeUtils.resolveReferenceType((DWType)dwType)) instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dwType;
            TriggerModel.Builder builder = TriggerModel.builder();
            QueryBuilderAdapter.configureBuilder(input, objectType, builder);
            return (TriggerModel)((TriggerModel.Builder)((TriggerModel.Builder)builder.withErrorModels(input.getErrorDefinitions())).withOrder(input.order())).build();
        }
        return input;
    }

    private static String toNamespacePrefix(String str) {
        return str.replace("::", "_").replace(".", "_");
    }

    private static <M extends ExecutableComponentModel<M>> void configureBuilder(ExecutableComponentModel<M> input, ObjectType objectType, ExecutableComponentModel.ExecutableComponentBuilder<M, ?> builder) {
        String ns = input.getModelReference() != null ? input.getModelReference().orElse(input.getName()) : input.getName();
        String namespace = QueryBuilderAdapter.toNamespacePrefix(ns);
        Map providerReferencesMap = ContextVariablesResolver.resolveContextVariablesOnInput((DWType)input.getInputType().getDataType());
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder.withName(input.getName()).withDisplayName(input.getDisplayName()).withOutputType(input.getOutputType()).withErrorOutputType(input.getErrorOutputType()).withInputType((TypeModel)new TypeModel.Builder().withDataType((DWType)QueryBuilderAdapter.createInputType(namespace, objectType, providerReferencesMap)).build()).isPaginated(input.isPaginated()).withModelReference((String)input.getModelReference().orElse(null))).resolvedInputProviders(QueryBuilderAdapter.createInputResolvers(providerReferencesMap)).withVersions(input.getVersions()).withIsBase(input.isBase());
    }

    static ObjectType createInputType(String namespace, ObjectType objectType, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers) {
        VectorBuilder props = new VectorBuilder();
        org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields = null;
        org.mule.weave.v2.api.tooling.ts.KeyValuePairType filter = null;
        org.mule.weave.v2.api.tooling.ts.KeyValuePairType orderBy = null;
        if (objectType.getProperties() != null) {
            org.mule.weave.v2.api.tooling.ts.KeyValuePairType[] inputProps;
            for (org.mule.weave.v2.api.tooling.ts.KeyValuePairType pair : inputProps = objectType.getProperties()) {
                DWType ivalue = pair.getValue();
                if (FlowMetadataUtils.isFieldSelector((DWType)ivalue)) {
                    projectedFields = pair;
                    continue;
                }
                if (FlowMetadataUtils.isResultSetFilter((DWType)ivalue)) {
                    filter = pair;
                    continue;
                }
                if (FlowMetadataUtils.isFieldOrder((DWType)ivalue)) {
                    orderBy = pair;
                    continue;
                }
                DWType ikey = pair.getKey();
                if (!(ikey instanceof WeaveType)) continue;
                WeaveType wtKey = (WeaveType)ikey;
                if (!(ivalue instanceof WeaveType)) continue;
                WeaveType wtValue = (WeaveType)ivalue;
                boolean optionalKey = pair.isOptionalKey();
                boolean repeated = pair.repeated();
                KeyValuePairType wtPair = new KeyValuePairType(wtKey, wtValue, optionalKey, repeated);
                props.$plus$eq((Object)wtPair);
            }
        }
        String projectedFieldsName = projectedFields != null ? projectedFields.getKeyName() : PROJECTED_FIELDS_FIELD;
        boolean projectedFieldsOptional = projectedFields != null && projectedFields.isOptionalKey();
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(projectedFieldsName), (WeaveType)QueryBuilderAdapter.createProjectedFieldsType(namespace, objectType, inputResolvers, projectedFields), projectedFieldsOptional));
        String filterName = filter != null ? filter.getKeyName() : FILTER_FIELD;
        boolean filterOptional = filter != null && filter.isOptionalKey();
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(filterName), (WeaveType)QueryBuilderAdapter.createQueryResultSetFilter(namespace, objectType, inputResolvers, projectedFields), filterOptional));
        if (Arrays.stream(objectType.getProperties()).anyMatch(t -> t.getKeyName().equalsIgnoreCase(ORDER_BY_FIELD))) {
            String orderByKey = orderBy != null ? orderBy.getKeyName() : ORDER_BY_FIELD;
            props.$plus$eq((Object)new KeyValuePairType((WeaveType)QueryBuilderAdapter.createKey(orderByKey), (WeaveType)QueryBuilderAdapter.createOrderByType(namespace, objectType, inputResolvers, projectedFields), true, false));
        }
        Metadata queryBuilder = new Metadata(FlowMetadataKey.QUERY_BUILDER.getKey(), (MetadataValue)new ObjectMetadataValue((Seq)new ListBuffer(), WEAVE_LOCATION), null);
        ArrayBuffer inputTypeMetadata = new ArrayBuffer();
        inputTypeMetadata.$plus$eq((Object)queryBuilder);
        ObjectType outObjectType = new ObjectType((Seq)props.result(), false, false);
        outObjectType._metadata_$eq(Option.apply((Object)inputTypeMetadata));
        return outObjectType;
    }

    static SimpleReferenceType createOrderByType(String namespace, ObjectType objectType, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        SimpleReferenceType orderByUnionType = QueryBuilderAdapter.extractOrderByUnionType(objectType);
        VectorBuilder properties = new VectorBuilder();
        QueryBuilderAdapter.addKindProperty((VectorBuilder<KeyValuePairType>)properties);
        String discriminatorTypeName = orderByUnionType.refName().name();
        discriminatorTypeName = QueryBuilderAdapter.addDiscriminatorSpecificProperties(discriminatorTypeName, (VectorBuilder<KeyValuePairType>)properties, namespace, inputResolvers, projectedFields);
        NameIdentifier typeId = new NameIdentifier(discriminatorTypeName, Option.empty());
        return QueryBuilderAdapter.buildSimpleReferenceType(typeId, (VectorBuilder<KeyValuePairType>)properties);
    }

    private static SimpleReferenceType extractOrderByUnionType(ObjectType objectType) {
        Optional<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> orderByProperty = Arrays.stream(objectType.getProperties()).filter(property -> property.getKeyName().equalsIgnoreCase(ORDER_BY_FIELD)).findFirst();
        try {
            UnionType unionType = (UnionType)orderByProperty.get().getValue();
            if (unionType.unionOf().length != 2) {
                throw new IllegalArgumentException();
            }
            return (SimpleReferenceType)unionType.unionOf()[1];
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid orderBy field structure: expected UnionType with only 2 elements", e);
        }
    }

    private static void addKindProperty(VectorBuilder<KeyValuePairType> properties) {
        StringType kindType = new StringType(Option.empty());
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(KIND_FIELD), (WeaveType)kindType));
    }

    private static String addDiscriminatorSpecificProperties(String discriminatorTypeName, VectorBuilder<KeyValuePairType> properties, String namespace, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        if (SINGLE_FIELD_ORDER_TYPE.equalsIgnoreCase(discriminatorTypeName) || SINGLE_FIELD_ORDER_TYPE_FULL_NAME.equalsIgnoreCase(discriminatorTypeName)) {
            discriminatorTypeName = SINGLE_FIELD_ORDER_TYPE;
            QueryBuilderAdapter.addSingleFieldOrderProperties(properties, inputResolvers, projectedFields);
        } else if (MANY_FIELDS_SINGLE_ORDER_TYPE.equalsIgnoreCase(discriminatorTypeName) || MANY_FIELDS_SINGLE_ORDER_TYPE_FULL_NAME.equalsIgnoreCase(discriminatorTypeName)) {
            discriminatorTypeName = MANY_FIELDS_SINGLE_ORDER_TYPE;
            QueryBuilderAdapter.addManyFieldsSingleOrderProperties(properties, inputResolvers, projectedFields);
        } else if (MANY_FIELDS_MANY_ORDER_TYPE.equalsIgnoreCase(discriminatorTypeName) || MANY_FIELDS_MANY_ORDER_TYPE_FULL_NAME.equalsIgnoreCase(discriminatorTypeName)) {
            discriminatorTypeName = MANY_FIELDS_MANY_ORDER_TYPE;
            QueryBuilderAdapter.addManyFieldsManyOrderProperties(properties, namespace, inputResolvers, projectedFields);
        } else {
            if (NO_ORDER_TYPE.equalsIgnoreCase(discriminatorTypeName) || NO_ORDER_TYPE_FULL_NAME.equalsIgnoreCase(discriminatorTypeName)) {
                throw new UnsupportedOperationException("Unsupported OrderBy sequence: QueryFieldNoOrder must be the first option of orderBy field.");
            }
            throw new UnsupportedOperationException(String.format("Unsupported OrderBy discriminator type: %s. Supported types are: %s, %s, %s", discriminatorTypeName, SINGLE_FIELD_ORDER_TYPE, MANY_FIELDS_SINGLE_ORDER_TYPE, MANY_FIELDS_MANY_ORDER_TYPE));
        }
        return discriminatorTypeName;
    }

    private static void addSingleFieldOrderProperties(VectorBuilder<KeyValuePairType> properties, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        WeaveType fieldType = QueryBuilderAdapter.createStringTypeWithValueProvider(FIELDS_VP, inputResolvers, projectedFields);
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey("field"), fieldType));
        StringType orderType = new StringType(Option.empty());
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(ORDER_PROPERTY_NAME), (WeaveType)orderType));
    }

    private static void addManyFieldsSingleOrderProperties(VectorBuilder<KeyValuePairType> properties, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        WeaveType fieldType = QueryBuilderAdapter.createStringTypeWithValueProvider(FIELDS_VP, inputResolvers, projectedFields);
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(FIELDS_FIELD), fieldType));
        StringType orderType = new StringType(Option.empty());
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(ORDER_PROPERTY_NAME), (WeaveType)orderType));
    }

    private static void addManyFieldsManyOrderProperties(VectorBuilder<KeyValuePairType> properties, String namespace, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        SimpleReferenceType fieldOrderPairType = QueryBuilderAdapter.createQueryFieldOrderPair(namespace, inputResolvers, projectedFields);
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(FIELDS_FIELD), (WeaveType)fieldOrderPairType));
    }

    static SimpleReferenceType createQueryFieldOrderPair(String namespace, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        String className = QueryBuilderAdapter.getApexClassName(namespace, FIELD_ORDER_PAIR_APEX_CLASS);
        NameIdentifier typeId = new NameIdentifier(className, Option.empty());
        VectorBuilder properties = new VectorBuilder();
        QueryBuilderAdapter.addFieldProperty((VectorBuilder<KeyValuePairType>)properties, inputResolvers, projectedFields);
        QueryBuilderAdapter.addOrderProperty((VectorBuilder<KeyValuePairType>)properties);
        return QueryBuilderAdapter.buildSimpleReferenceType(typeId, (VectorBuilder<KeyValuePairType>)properties);
    }

    private static void addFieldProperty(VectorBuilder<KeyValuePairType> properties, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        WeaveType fieldType = QueryBuilderAdapter.createStringTypeWithValueProvider(FIELDS_VP, inputResolvers, projectedFields);
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey("field"), fieldType));
    }

    private static void addOrderProperty(VectorBuilder<KeyValuePairType> properties) {
        StringType orderType = new StringType(Option.empty());
        properties.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(ORDER_PROPERTY_NAME), (WeaveType)orderType));
    }

    private static WeaveType createStringTypeWithValueProvider(String valueProviderName, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        ArrayBuffer metadata = new ArrayBuffer();
        ObjectMetadataValue valueProviderMetadata = QueryBuilderAdapter.createValueProviderMetadataObjectType(valueProviderName, inputResolvers, projectedFields);
        metadata.$plus$eq((Object)new Metadata(VALUE_PROVIDER, (MetadataValue)valueProviderMetadata, null));
        StringType stringType = new StringType(Option.empty());
        stringType._metadata_$eq(Option.apply((Object)metadata));
        return stringType;
    }

    private static SimpleReferenceType buildSimpleReferenceType(NameIdentifier typeId, VectorBuilder<KeyValuePairType> properties) {
        ObjectType objectType = new ObjectType((Seq)properties.result(), false, false);
        StaticTypeRef typeRef = new StaticTypeRef((WeaveType)objectType);
        Metadata queryBuilder = new Metadata(FlowMetadataKey.FIELD_ORDER.getKey(), (MetadataValue)new ObjectMetadataValue((Seq)new ListBuffer(), WEAVE_LOCATION), null);
        ArrayBuffer inputTypeMetadata = new ArrayBuffer();
        inputTypeMetadata.$plus$eq((Object)queryBuilder);
        SimpleReferenceType orderBy = new SimpleReferenceType(typeId, Option.empty(), (TypeRef)typeRef);
        orderBy._metadata_$eq(Option.apply((Object)inputTypeMetadata));
        return orderBy;
    }

    static SimpleReferenceType createProjectedFieldsType(String namespace, ObjectType objectType, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        String className = QueryBuilderAdapter.getApexClassName(namespace, PROJECTED_FIELDS_APEX_CLASS);
        NameIdentifier id = new NameIdentifier(className, Option.empty());
        VectorBuilder props = new VectorBuilder();
        StringType kindValue = new StringType(Option.empty());
        ArrayBuffer kindDiscriminatorsArray = new ArrayBuffer();
        QueryBuilderAdapter.findProjectedFieldsDiscriminators(objectType).forEach(discriminator -> kindDiscriminatorsArray.$plus$eq((Object)new LiteralMetadataValue(discriminator, STRING_TYPE, WEAVE_LOCATION)));
        ArrayMetadataValue kindDiscriminators = new ArrayMetadataValue((Seq)kindDiscriminatorsArray, WEAVE_LOCATION);
        Metadata kindDiscriminatorAnnotation = new Metadata("discriminator", (MetadataValue)new LiteralMetadataValue(KIND_FIELD, STRING_TYPE, WEAVE_LOCATION), null);
        ArrayBuffer kindMetadata = new ArrayBuffer();
        kindMetadata.$plus$eq((Object)new Metadata(VALUE_PROVIDER, (MetadataValue)QueryBuilderAdapter.createValueProviderMetadata(PROJECTED_DISCRIMINATORS_VP), null));
        kindMetadata.$plus$eq((Object)new Metadata(DISCRIMINATORS, (MetadataValue)kindDiscriminators, null));
        kindMetadata.$plus$eq((Object)kindDiscriminatorAnnotation);
        kindValue._metadata_$eq(Option.apply((Object)kindMetadata));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(KIND_FIELD), (WeaveType)kindValue));
        ArrayBuffer fieldsMetadata = new ArrayBuffer();
        fieldsMetadata.$plus$eq((Object)new Metadata(VALUE_PROVIDER, (MetadataValue)QueryBuilderAdapter.createValueProviderMetadataObjectType(FIELDS_VP, inputResolvers, projectedFields), null));
        Metadata fieldSelector = new Metadata(FlowMetadataKey.FIELD_SELECTOR.getKey(), (MetadataValue)new ObjectMetadataValue((Seq)new ListBuffer(), WEAVE_LOCATION), null);
        fieldsMetadata.$plus$eq((Object)fieldSelector);
        ArrayType fieldsValue = new ArrayType(STRING_TYPE);
        fieldsValue._metadata_$eq(Option.apply((Object)fieldsMetadata));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(FIELDS_FIELD), (WeaveType)fieldsValue));
        ObjectType pfType = new ObjectType((Seq)props.result(), false, false);
        StaticTypeRef typeRef = new StaticTypeRef((WeaveType)pfType);
        SimpleReferenceType referenceType = new SimpleReferenceType(id, Option.empty(), (TypeRef)typeRef);
        referenceType._metadata_$eq(Option.apply((Object)fieldsMetadata));
        return referenceType;
    }

    static SimpleReferenceType createQueryResultSetFilter(String namespace, ObjectType objectType, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        String className = QueryBuilderAdapter.getApexClassName(namespace, FILTER_APEX_CLASS);
        NameIdentifier id = new NameIdentifier(className, Option.empty());
        VectorBuilder props = new VectorBuilder();
        StringType kindValue = new StringType(Option.empty());
        ArrayBuffer kindDiscriminatorsArray = new ArrayBuffer();
        QueryBuilderAdapter.findFilterDiscriminators(objectType).forEach(discriminator -> kindDiscriminatorsArray.$plus$eq((Object)new LiteralMetadataValue(discriminator, STRING_TYPE, WEAVE_LOCATION)));
        ArrayMetadataValue kindDiscriminators = new ArrayMetadataValue((Seq)kindDiscriminatorsArray, WEAVE_LOCATION);
        Metadata kindDiscriminatorAnnotation = new Metadata("discriminator", (MetadataValue)new LiteralMetadataValue(KIND_FIELD, STRING_TYPE, WEAVE_LOCATION), null);
        ArrayBuffer kindMetadata = new ArrayBuffer();
        kindMetadata.$plus$eq((Object)new Metadata(VALUE_PROVIDER, (MetadataValue)QueryBuilderAdapter.createValueProviderMetadata(FILTER_DISCRIMINATORS_VP), null));
        kindMetadata.$plus$eq((Object)new Metadata(DISCRIMINATORS, (MetadataValue)kindDiscriminators, null));
        kindMetadata.$plus$eq((Object)kindDiscriminatorAnnotation);
        kindValue._metadata_$eq(Option.apply((Object)kindMetadata));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(KIND_FIELD), (WeaveType)kindValue));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(EXPRESSION_FIELD), STRING_TYPE));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(CONDITIONS_FIELD), (WeaveType)QueryBuilderAdapter.createQueryFilterCondition(namespace, inputResolvers, projectedFields)));
        ArrayBuffer fieldsMetadata = new ArrayBuffer();
        Metadata fieldSelector = new Metadata(FlowMetadataKey.RESULT_SET_FILTER.getKey(), (MetadataValue)new ObjectMetadataValue((Seq)new ListBuffer(), WEAVE_LOCATION), null);
        fieldsMetadata.$plus$eq((Object)fieldSelector);
        ObjectType rsFilter = new ObjectType((Seq)props.result(), false, false);
        StaticTypeRef typeRef = new StaticTypeRef((WeaveType)rsFilter);
        SimpleReferenceType referenceType = new SimpleReferenceType(id, Option.empty(), (TypeRef)typeRef);
        referenceType._metadata_$eq(Option.apply((Object)fieldsMetadata));
        return referenceType;
    }

    static SimpleReferenceType createQueryFilterCondition(String namespace, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        String className = QueryBuilderAdapter.getApexClassName(namespace, CONDITION_APEX_CLASS);
        NameIdentifier id = new NameIdentifier(className, Option.empty());
        VectorBuilder props = new VectorBuilder();
        ArrayBuffer fieldNameMetadata = new ArrayBuffer();
        fieldNameMetadata.$plus$eq((Object)new Metadata(VALUE_PROVIDER, (MetadataValue)QueryBuilderAdapter.createValueProviderMetadataObjectType(FIELDS_VP, inputResolvers, projectedFields), null));
        StringType fieldNameValue = new StringType(Option.empty());
        fieldNameValue._metadata_$eq(Option.apply((Object)fieldNameMetadata));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey("field"), (WeaveType)fieldNameValue));
        ArrayBuffer operatorMetadata = new ArrayBuffer();
        operatorMetadata.$plus$eq((Object)new Metadata(VALUE_PROVIDER, (MetadataValue)QueryBuilderAdapter.createValueProviderMetadata(OPERATORS_VP), null));
        StringType operatorValue = new StringType(Option.empty());
        operatorValue._metadata_$eq(Option.apply((Object)operatorMetadata));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(OPERATOR_FIELD), (WeaveType)operatorValue));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(VALUE_FIELD), STRING_TYPE));
        props.$plus$eq((Object)QueryBuilderAdapter.createPair((WeaveType)QueryBuilderAdapter.createKey(VALUES_FIELD), (WeaveType)STRING_ARRAY_TYPE));
        ObjectType objectType = new ObjectType((Seq)props.result(), false, false);
        StaticTypeRef typeRef = new StaticTypeRef((WeaveType)objectType);
        return new SimpleReferenceType(id, Option.empty(), (TypeRef)typeRef);
    }

    static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> createInputResolvers(Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers) {
        HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolvers = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>(inputResolvers);
        ArrayList emptyArguments = new ArrayList();
        ObjectFieldSelector pfKind = new ObjectFieldSelector(false, new String[]{PROJECTED_FIELDS_FIELD, KIND_FIELD});
        ProviderReference projectedDiscriminatorsValueProviderRef = new ProviderReference(PROJECTED_DISCRIMINATORS_VP, emptyArguments);
        ExecutableComponentModel.ProviderReferences projectedDiscriminatorsValueProvider = new ExecutableComponentModel.ProviderReferences(projectedDiscriminatorsValueProviderRef, null);
        resolvers.put(pfKind, projectedDiscriminatorsValueProvider);
        ObjectFieldSelector filterKind = new ObjectFieldSelector(false, new String[]{FILTER_FIELD, KIND_FIELD});
        ProviderReference filterDiscriminatorsValueProviderRef = new ProviderReference(FILTER_DISCRIMINATORS_VP, emptyArguments);
        ExecutableComponentModel.ProviderReferences filterDiscriminatorsValueProvider = new ExecutableComponentModel.ProviderReferences(filterDiscriminatorsValueProviderRef, null);
        resolvers.put(filterKind, filterDiscriminatorsValueProvider);
        return resolvers;
    }

    static KeyType createKey(String name) {
        return new KeyType((WeaveType)new NameType(Option.apply((Object)new QName(name, Option.empty()))), EMPTY_LIST);
    }

    static KeyValuePairType createPair(WeaveType key, WeaveType value) {
        return new KeyValuePairType(key, value, false, false);
    }

    static KeyValuePairType createPair(WeaveType key, WeaveType value, boolean optional) {
        return new KeyValuePairType(key, value, optional, false);
    }

    static List<String> findProjectedFieldsDiscriminators(ObjectType objectType) {
        return QueryBuilderAdapter.findDiscriminators(objectType, FlowMetadataKey.FIELD_SELECTOR);
    }

    static List<String> findFilterDiscriminators(ObjectType objectType) {
        return QueryBuilderAdapter.findDiscriminators(objectType, FlowMetadataKey.RESULT_SET_FILTER);
    }

    static List<String> findDiscriminators(ObjectType objectType, FlowMetadataKey key) {
        Option filter = objectType.properties().find(pair -> MetadataUtils.getMetadata((DWType)pair.getValue(), (String)key.getKey()).isPresent());
        if (filter.isDefined()) {
            return QUERY_BUILDER_SUPPORT.makeParameterDiscriminator((org.mule.weave.v2.api.tooling.ts.KeyValuePairType)filter.get());
        }
        return new ArrayList<String>();
    }

    static ObjectMetadataValue createValueProviderMetadata(String name) {
        KeyValuePairMetadataValue valueProviderName = new KeyValuePairMetadataValue(NAME, (MetadataValue)new LiteralMetadataValue(name, STRING_TYPE, WEAVE_LOCATION), WEAVE_LOCATION);
        ListBuffer props = new ListBuffer();
        props.$plus$eq((Object)valueProviderName);
        return new ObjectMetadataValue((Seq)props, WEAVE_LOCATION);
    }

    static ObjectMetadataValue createValueProviderMetadataObjectType(String defaultName, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers, org.mule.weave.v2.api.tooling.ts.KeyValuePairType projectedFields) {
        String projectedFieldsName = projectedFields != null ? projectedFields.getKeyName() : PROJECTED_FIELDS_FIELD;
        ObjectFieldSelector projectedFieldsOFS = new ObjectFieldSelector(false, new String[]{projectedFieldsName, FIELDS_FIELD});
        ExecutableComponentModel.ProviderReferences ref = inputResolvers.get(projectedFieldsOFS);
        ArrayList projectedFieldsVPArgs = ref != null && ref.getValueProviderReference() != null ? ref.getValueProviderReference().getArguments() : new ArrayList();
        String vpName = ref != null && ref.getValueProviderReference() != null ? ref.getValueProviderReference().getName() : defaultName;
        ListBuffer argProps = new ListBuffer();
        if (!projectedFieldsVPArgs.isEmpty()) {
            for (ProviderArgument providerArgument : projectedFieldsVPArgs) {
                String[] parameterSelectors = providerArgument.getParameterSelector().getPath();
                String[] inputSelectors = providerArgument.getInputSelector() instanceof ObjectFieldSelector ? ((ObjectFieldSelector)providerArgument.getInputSelector()).getPath() : new String[]{};
                for (int i = 0; i < parameterSelectors.length && i < inputSelectors.length; ++i) {
                    KeyValuePairMetadataValue argProp = new KeyValuePairMetadataValue(parameterSelectors[i], (MetadataValue)new LiteralMetadataValue("/" + inputSelectors[i], STRING_TYPE, WEAVE_LOCATION), WEAVE_LOCATION);
                    argProps.$plus$eq((Object)argProp);
                }
            }
        } else {
            KeyValuePairMetadataValue objectType = new KeyValuePairMetadataValue(OBJECT_TYPE_FIELD, (MetadataValue)new LiteralMetadataValue(OBJECT_TYPE_PATH, STRING_TYPE, WEAVE_LOCATION), WEAVE_LOCATION);
            argProps.$plus$eq((Object)objectType);
        }
        KeyValuePairMetadataValue valueProviderName = new KeyValuePairMetadataValue(NAME, (MetadataValue)new LiteralMetadataValue(vpName, STRING_TYPE, WEAVE_LOCATION), WEAVE_LOCATION);
        ObjectMetadataValue args = new ObjectMetadataValue((Seq)argProps, WEAVE_LOCATION);
        ListBuffer props = new ListBuffer();
        props.$plus$eq((Object)valueProviderName);
        props.$plus$eq((Object)new KeyValuePairMetadataValue(ARGUMENTS, (MetadataValue)args, WEAVE_LOCATION));
        return new ObjectMetadataValue((Seq)props, WEAVE_LOCATION);
    }

    static String getApexClassName(String namespace, String className) {
        return String.format("%s_%s", namespace, className);
    }

    public static class StaticTypeRef
    implements TypeRef {
        private final WeaveType weaveType;

        public StaticTypeRef(WeaveType weaveType) {
            this.weaveType = weaveType;
        }

        public WeaveType ref() {
            return this.weaveType;
        }
    }
}

