/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Message;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.HashMap;
import java.util.Map;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.ts.SimpleReferenceType;
import scala.Tuple3;

public class ReferenceTypesUniqueNamesRule
extends Rule<Message> {
    private final Map<String, String> namesToFQNNames = new HashMap<String, String>();

    public ReferenceTypesUniqueNamesRule() {
        super(Message.class);
    }

    protected void validate(Validatable<Message> validatable, ValidationContext ctx) {
        this.checkUniqueNames(((Message)validatable.getElement()).getType(), ctx);
    }

    private void checkUniqueNames(DWType type, ValidationContext ctx) {
        if (type instanceof SimpleReferenceType) {
            SimpleReferenceType referenceType = (SimpleReferenceType)type;
            String fqn = ((NameIdentifier)((Tuple3)referenceType.referencedTypeDef().get())._1()).fullQualifiedName();
            String[] values = fqn.split("::");
            String name = values[values.length - 1];
            this.namesToFQNNames.compute(name, (k, v) -> {
                if (v == null) {
                    return fqn;
                }
                int comp = v.compareTo(fqn);
                if (comp != 0) {
                    String second;
                    String first;
                    if (comp < 0) {
                        first = v;
                        second = fqn;
                    } else {
                        first = fqn;
                        second = v;
                    }
                    ctx.addError((Location)referenceType.location(), String.format("Name %s already used by %s for type %s", name, first, second), "connector");
                }
                return v;
            });
            this.checkUniqueNames(TypeUtils.resolveReferenceType((DWType)referenceType), ctx);
            return;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            this.checkUniqueNames(arrayType.arrayOf(), ctx);
            return;
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            for (KeyValuePairType keyValuePairType : objectType.getProperties()) {
                this.checkUniqueNames(keyValuePairType.getValue(), ctx);
            }
            return;
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            for (DWType dwType : unionType.unionOf()) {
                this.checkUniqueNames(dwType, ctx);
            }
            return;
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)type;
            for (DWType dwType : intersectionType.intersectionOf()) {
                this.checkUniqueNames(dwType, ctx);
            }
        }
    }
}

