/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.flow.api.validator.rules.QueryBuilderUnionRule;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class ResultSetsInTriggersRule
extends Rule<UnionType> {
    private static final Set<String> SUPPORTED_FILTERS = Set.of("AND", "CUSTOM");

    public ResultSetsInTriggersRule() {
        super(UnionType.class);
    }

    protected void validate(Validatable<UnionType> validatable, ValidationContext ctx) {
        UnionType type = (UnionType)validatable.getElement();
        Optional<DWMetadata> discriminatorMetadata = QueryBuilderUnionRule.getDiscriminatorMetadata(type);
        if (discriminatorMetadata.isPresent()) {
            List data = MetadataValueUtils.asProperties((DWMetadataValue)discriminatorMetadata.get().getValue());
            String discriminator = MetadataValueUtils.requireStringProperty((List)data, (String)"key");
            boolean hasAndFilter = Arrays.stream(type.unionOf()).anyMatch(t -> this.hasFilter((DWType)t, discriminator));
            if (!hasAndFilter) {
                ctx.addError(type.getLocation(), "Trigger must support having 'AND' conditions, at input: " + String.valueOf(type), "InvalidFlowType");
            }
        }
    }

    public boolean appliesTo(Validatable<UnionType> validatable) {
        return super.appliesTo(validatable) && validatable.hasContext(ValidatableType.TRIGGER) && Arrays.stream(((UnionType)validatable.getElement()).getTypeMetadata()).anyMatch(m -> FlowMetadataKey.RESULT_SET_FILTER.getKey().equals(m.getName()));
    }

    private boolean hasFilter(DWType type, String discriminator) {
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            return this.hasFilter(referenceType.resolveType(), discriminator);
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            return Arrays.stream(objectType.getProperties()).anyMatch(p -> p.getKeyName().equals(discriminator) && p.getValue() instanceof StringType && ((StringType)p.getValue()).getValue().isPresent() && SUPPORTED_FILTERS.contains(((StringType)p.getValue()).getValue().get()));
        }
        return false;
    }
}

