/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.EnumComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyComponent;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.weave.v2.api.tooling.ts.AnyType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationManager;
import org.mule.weave.v2.ts.TypeHelper;
import org.mule.weave.v2.ts.WeaveType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

abstract class UnionTypeHandler
extends TypeHandler {
    UnionTypeHandler(ComponentRegistry componentRegistry) {
        super(componentRegistry);
    }

    @Override
    public boolean handles(DWType type) {
        return type instanceof UnionType;
    }

    @Override
    public String getTypeName() {
        return "UnionType";
    }

    @Override
    public Component make(DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        if (!(dwType instanceof UnionType)) {
            throw new AssertionError();
        }
        List<DWType> of = Arrays.stream(this.unionElements(dwType, outer instanceof PropertyComponent)).filter(e -> !(e instanceof NullType)).filter(e -> !(e instanceof AnyType)).toList();
        if (of.isEmpty()) {
            return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("Any")).build();
        }
        DWType headType = TypeUtils.resolveReferenceType((DWType)of.get(0));
        boolean notHeterogeneous = of.stream().anyMatch(a -> !TypeUtils.resolveReferenceType((DWType)a).getClass().equals(headType.getClass()));
        if (notHeterogeneous) {
            System.err.println("Error: Not Heterogeneous Union: please check type: " + typeName + " in service: " + this.componentRegistry.getServiceComponent().getName());
            return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("Any")).build();
        }
        if (headType instanceof BooleanType) {
            return typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
        }
        if (headType instanceof StringType || headType instanceof NumberType) {
            if (this.isEnumType(headType)) {
                Map<String, String> enumValues = this.createEnumValues(of);
                Component enumComponent = ((EnumComponent.EnumComponentBuilder)((EnumComponent.EnumComponentBuilder)((EnumComponent.EnumComponentBuilder)EnumComponent.builder().name(outer.getName())).outer(outer.getId())).enumValues(enumValues)).build();
                Component enumType = typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
                enumType = this.componentRegistry.registerComponent(enumType);
                ((EnumComponent)enumComponent).setElementType(enumType.getId());
                return enumComponent;
            }
            return typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
        }
        DWType resolvedUnion = this.resolveUnionFromSeq(of);
        if (resolvedUnion instanceof UnionType) {
            throw new RuntimeException("Error: Not Able to simplify Union: `" + String.valueOf(dwType) + "` please check type: " + typeName + " in service: " + this.componentRegistry.getServiceComponent().getName());
        }
        this.onComponentResolution(resolvedUnion, outer);
        return typeFactory.make(resolvedUnion, typeName, outer);
    }

    private boolean isEnumType(DWType type) {
        StringType t;
        if (type instanceof StringType && (t = (StringType)type).getValue().isPresent()) {
            return true;
        }
        return type instanceof NumberType && (t = (NumberType)type).getValue().isPresent();
    }

    private Map<String, String> createEnumValues(List<DWType> options) {
        return options.stream().filter(Objects::nonNull).map(option -> {
            if (option instanceof StringType) {
                return (String)((StringType)option).getValue().get();
            }
            return option.toString();
        }).distinct().collect(Collectors.toMap(item -> item, item -> item));
    }

    protected DWType resolveUnionFromSeq(List<DWType> of) {
        TypeHelper helper = new TypeHelper(new ParsingNotificationManager());
        Seq seq = JavaConverters.collectionAsScalaIterable((Collection)of.stream().map(a -> (WeaveType)a).collect(Collectors.toList())).toSeq();
        return helper.resolveUnion(helper.unify(seq));
    }

    protected DWType[] unionElements(DWType type, boolean isPropertyComponent) {
        if (type instanceof UnionType) {
            UnionType union = (UnionType)type;
            return (DWType[])Arrays.stream(union.unionOf()).flatMap(e -> Arrays.stream(this.unionElements((DWType)e, isPropertyComponent))).toArray(DWType[]::new);
        }
        if (type instanceof ReferenceType) {
            return this.unionElements(TypeUtils.resolveReferenceType((DWType)type), isPropertyComponent);
        }
        return new DWType[]{type};
    }

    abstract void onComponentResolution(DWType var1, Component var2);
}

