/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class FlowConnectionsRule
extends Rule<ObjectType> {
    public FlowConnectionsRule() {
        super(ObjectType.class, ValidatableType.CONNECTOR);
    }

    protected void validate(Validatable<ObjectType> validatable, ValidationContext ctx) {
        Optional connectionsProperty = TypeUtils.getObjectProperty((DWType)((DWType)validatable.getElement()), (String)"connections");
        if (connectionsProperty.isEmpty()) {
            return;
        }
        KeyValuePairType[] keyValuePairTypeArray = ((KeyValuePairType)connectionsProperty.get()).getValue();
        if (!(keyValuePairTypeArray instanceof ObjectType)) {
            ctx.addError(((KeyValuePairType)connectionsProperty.get()).getLocation(), "Invalid type for property 'connections'. Expected: Object; Actual: " + ((KeyValuePairType)connectionsProperty.get()).getValue().toString(), "connector");
            return;
        }
        ObjectType connectionsObject = (ObjectType)keyValuePairTypeArray;
        for (KeyValuePairType keyValuePairType : connectionsObject.getProperties()) {
            DWType weaveType = TypeUtils.resolveReferenceType((DWType)keyValuePairType.getValue());
            ctx.queue(ctx.validatable((Object)weaveType).withType(ValidatableType.CONNECTION).withName(keyValuePairType.getKeyName()).build());
        }
    }
}

