/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import com.google.gson.Gson;
import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.ParameterAnnotationUtil;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationKind;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyBinding;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ProviderArgumentInfo;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ProviderMetadataBinding;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.RequestParameterBinding;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderSupport;
import com.mulesoft.connectivity.flow.internal.servicemodel.serializer.r256.util.R256ProviderReferenceResolver;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;

public class BindingSupport {
    private final Gson gson = new Gson();
    private final QueryBuilderSupport queryBuilderSupport = new QueryBuilderSupport();

    public Optional<String> getInParameterBinding(ExecutableComponentModel<?> operationModel, KeyValuePairType fieldType, String inParameterName) {
        Optional<ProviderReferenceWithKind> providerReferenceWithKind = this.getProviderReferenceWithKind(operationModel, inParameterName);
        boolean hasResolvedInputProvider = operationModel.hasResolvedInputProvider(new ObjectFieldSelector(false, Collections.singletonList(inParameterName)));
        ParameterAnnotationUtil parameterAnnotationUtil = new ParameterAnnotationUtil();
        parameterAnnotationUtil.setAnnotations(fieldType);
        if (FlowMetadataUtils.isQueryBuilder((DWType)operationModel.getInputType().getDataType()) && !hasResolvedInputProvider) {
            ProviderMetadataBinding providerBinding = new ProviderMetadataBinding();
            providerBinding.setQueryBuilderParameterBinding(this.queryBuilderSupport.processParameterAnnotations(fieldType));
            RequestParameterBinding parameterBinding = new RequestParameterBinding();
            parameterBinding.setProvider(providerBinding);
            parameterBinding.setAnnotations(parameterAnnotationUtil.getAnnotations());
            return Optional.of(this.gson.toJson((Object)parameterBinding));
        }
        if (providerReferenceWithKind.isPresent()) {
            ProviderReferenceWithKind referenceType = providerReferenceWithKind.get();
            ProviderMetadataBinding providerBinding = new ProviderMetadataBinding();
            providerBinding.setOperation(referenceType.providerReference().getName());
            providerBinding.setOperationKind(referenceType.operationKind().getValue());
            providerBinding.setDependsOn(BindingSupport.getDependsOn(referenceType.providerReference().getArguments()));
            RequestParameterBinding parameterBinding = new RequestParameterBinding();
            parameterBinding.setProvider(providerBinding);
            parameterBinding.setAnnotations(parameterAnnotationUtil.getAnnotations());
            return Optional.of(this.gson.toJson((Object)parameterBinding));
        }
        return Optional.empty();
    }

    public Optional<String> getOutParameterBinding(ExecutableComponentModel<?> operationModel) {
        return this.getOutputTypeProviderReferenceWithKind(operationModel, List.of()).map(referenceType -> {
            ProviderMetadataBinding providerBinding = new ProviderMetadataBinding();
            providerBinding.setOperation(referenceType.providerReference().getName());
            providerBinding.setOperationKind(OperationKind.TYPE_PROVIDER.getValue());
            providerBinding.setDependsOn(BindingSupport.getDependsOn(referenceType.providerReference().getArguments()));
            RequestParameterBinding parameterBinding = new RequestParameterBinding();
            parameterBinding.setProvider(providerBinding);
            parameterBinding.setAnnotations(new HashMap<String, Map<String, Object>>());
            return this.gson.toJson((Object)parameterBinding);
        });
    }

    public Optional<String> getPropertyBinding(ExecutableComponentModel<?> operationModel, KeyValuePairType fieldType, List<String> path) {
        return this.getValueProviderReferenceWithKind(operationModel, path).or(() -> this.getInputTypeProviderReferenceWithKind(operationModel, path)).or(() -> this.getOutputTypeProviderReferenceWithKind(operationModel, path)).map(referenceType -> {
            ParameterAnnotationUtil parameterAnnotationUtil = new ParameterAnnotationUtil();
            parameterAnnotationUtil.setAnnotations(fieldType);
            ProviderMetadataBinding providerBinding = new ProviderMetadataBinding();
            providerBinding.setOperation(referenceType.providerReference().getName());
            providerBinding.setOperationKind(referenceType.operationKind().getValue());
            providerBinding.setDependsOn(BindingSupport.getDependsOn(referenceType.providerReference().getArguments()));
            PropertyBinding propertyBinding = new PropertyBinding();
            propertyBinding.setProvider(providerBinding);
            propertyBinding.setAnnotations(parameterAnnotationUtil.getAnnotations());
            if (FlowMetadataUtils.isQueryBuilder((DWType)operationModel.getInputType().getDataType())) {
                providerBinding.setQueryBuilderParameterBinding(this.queryBuilderSupport.processPropertyAnnotations(fieldType));
            }
            return this.gson.toJson((Object)propertyBinding);
        });
    }

    public static List<ProviderArgumentInfo> getDependsOn(List<ProviderArgument> providerArguments) {
        ArrayList<ProviderArgumentInfo> dependsOn = new ArrayList<ProviderArgumentInfo>();
        for (ProviderArgument providerArgument : providerArguments) {
            dependsOn.add(new ProviderArgumentInfo(Arrays.asList(providerArgument.getParameterSelector().getPath()), Arrays.asList(((ObjectFieldSelector)providerArgument.getInputSelector()).getPath())));
        }
        return dependsOn;
    }

    Optional<ProviderReferenceWithKind> getValueProviderReferenceWithKind(ExecutableComponentModel<?> operationModel, List<String> path) {
        return R256ProviderReferenceResolver.getValueProviderReference(operationModel, path).map(providerReference -> new ProviderReferenceWithKind((ProviderReference)providerReference, OperationKind.VALUE_PROVIDER));
    }

    Optional<ProviderReferenceWithKind> getInputTypeProviderReferenceWithKind(ExecutableComponentModel<?> operationModel, List<String> path) {
        return R256ProviderReferenceResolver.getInputTypeProviderReference(operationModel, path).map(providerReference -> new ProviderReferenceWithKind((ProviderReference)providerReference, OperationKind.TYPE_PROVIDER));
    }

    Optional<ProviderReferenceWithKind> getOutputTypeProviderReferenceWithKind(ExecutableComponentModel<?> operationModel, List<String> path) {
        return R256ProviderReferenceResolver.getOutputTypeProviderReference(operationModel, path).map(providerReference -> new ProviderReferenceWithKind((ProviderReference)providerReference, OperationKind.TYPE_PROVIDER));
    }

    Optional<ProviderReferenceWithKind> getProviderReferenceWithKind(ExecutableComponentModel<?> operationModel, String keyName) {
        List<String> path = Collections.singletonList(keyName);
        return this.getValueProviderReferenceWithKind(operationModel, path).or(() -> this.getInputTypeProviderReferenceWithKind(operationModel, path));
    }

    record ProviderReferenceWithKind(ProviderReference providerReference, OperationKind operationKind) {
    }
}

