/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ProviderCapableTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.ts.WeaveType;

class ReferenceTypeHandler
extends ProviderCapableTypeHandler {
    private final Map<String, Component> resolvedTypes = new HashMap<String, Component>();
    private final Set<String> visiting = new HashSet<String>();
    private final Patch patch;

    ReferenceTypeHandler(ComponentRegistry componentRegistry) {
        super(componentRegistry);
        this.patch = null;
    }

    ReferenceTypeHandler(ComponentRegistry componentRegistry, Patch patch) {
        super(componentRegistry);
        this.patch = patch;
    }

    @Override
    public Component makeWithProvider(ExecutableComponentModel<?> componentModel, DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        assert (dwType instanceof ReferenceType);
        ReferenceType referenceType = (ReferenceType)dwType;
        if (this.patch != null && this.patch.shouldExplodeReferenceType(this.extractCandidate(referenceType.getReferenceTypeName()), outer, typeFactory)) {
            return typeFactory.make(referenceType.resolveType(), typeName, outer);
        }
        DWType resolvedType = referenceType.resolveType();
        DWMetadata[] typeMetadata = dwType.getTypeMetadata();
        String referenceTypeName = referenceType.getReferenceTypeName();
        if (this.resolvedTypes.containsKey(referenceTypeName)) {
            return this.resolvedTypes.get(referenceTypeName);
        }
        this.visiting.add(referenceTypeName);
        String shortTypeName = this.getShortTypeName(referenceTypeName);
        DWType referenceOrCloneType = this.getWeaveType((WeaveType)dwType, typeMetadata, resolvedType);
        Component type = typeFactory.getProviderCapableTypeHandlers().stream().anyMatch(x -> x.handles(referenceOrCloneType.getBaseType())) ? typeFactory.makeWithProvider(componentModel, referenceOrCloneType, shortTypeName, outer) : typeFactory.make(referenceOrCloneType, shortTypeName, outer);
        this.resolvedTypes.put(referenceTypeName, type);
        this.visiting.remove(referenceTypeName);
        return type;
    }

    @Override
    public boolean handles(DWType type) {
        return type instanceof ReferenceType;
    }

    @Override
    public String getTypeName() {
        return "ReferenceType";
    }

    @Override
    public Component make(DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        assert (dwType instanceof ReferenceType);
        ReferenceType referenceType = (ReferenceType)dwType;
        if (this.patch != null && this.patch.shouldExplodeReferenceType(this.extractCandidate(referenceType.getReferenceTypeName()), outer, typeFactory)) {
            return typeFactory.make(referenceType.resolveType(), typeName, outer);
        }
        DWType resolvedType = referenceType.resolveType();
        DWMetadata[] typeMetadata = dwType.getTypeMetadata();
        String referenceTypeName = referenceType.getReferenceTypeName();
        if (this.resolvedTypes.containsKey(referenceTypeName)) {
            return this.resolvedTypes.get(referenceTypeName);
        }
        String shortTypeName = this.getShortTypeName(referenceTypeName);
        this.visiting.add(referenceTypeName);
        DWType referenceOrCloneType = this.getWeaveType((WeaveType)dwType, typeMetadata, resolvedType);
        Component type = typeFactory.make(referenceOrCloneType, shortTypeName, outer);
        this.resolvedTypes.put(referenceTypeName, type);
        this.visiting.remove(shortTypeName);
        return type;
    }

    private String getShortTypeName(String referenceTypeName) {
        String candidate = this.extractCandidate(referenceTypeName);
        if (candidate == null) {
            return referenceTypeName;
        }
        this.validateUniqueness(candidate);
        return candidate;
    }

    private String extractCandidate(String referenceTypeName) {
        if ((referenceTypeName = referenceTypeName.replaceAll("[<>, {}:]", "_")).contains("_T_")) {
            return this.extractType(referenceTypeName, "_T_", "T_");
        }
        if (referenceTypeName.contains("_O_")) {
            return this.extractType(referenceTypeName, "_O_", "O_");
        }
        if (referenceTypeName.contains("Types_")) {
            String[] parts = referenceTypeName.split("Types_");
            return parts[parts.length - 1];
        }
        return referenceTypeName;
    }

    private String extractType(String referenceTypeName, String delimiter, String prefix) {
        String[] parts = referenceTypeName.split(delimiter);
        return prefix + parts[parts.length - 1];
    }

    private void validateUniqueness(String candidate) {
        Component serviceComponent = this.componentRegistry.getServiceComponent();
        this.componentRegistry.getComponents().values().stream().filter(x -> ComponentType.OBJECT.equals((Object)x.getComponentType())).filter(x -> serviceComponent.getId().equals(x.getOuter())).filter(x -> candidate.equals(x.getName())).filter(x -> !this.visiting.contains(x.getName())).findFirst().ifPresent(x -> {
            throw new RuntimeException("Duplicate reference type: " + x.getName());
        });
    }

    private DWType getWeaveType(WeaveType metadataType, DWMetadata[] typeMetadata, DWType resolvedType) {
        if (typeMetadata != null && typeMetadata.length > 0) {
            WeaveType weaveType = (WeaveType)resolvedType;
            WeaveType clonedType = weaveType.cloneType();
            metadataType.copyMetadataTo(clonedType);
            return clonedType;
        }
        return resolvedType;
    }
}

