/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.EnumComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.weave.v2.api.tooling.ts.AnyType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationManager;
import org.mule.weave.v2.ts.TypeHelper;
import org.mule.weave.v2.ts.WeaveType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

abstract class UnionTypeHandler
extends TypeHandler {
    UnionTypeHandler(ComponentRegistry componentRegistry) {
        super(componentRegistry);
    }

    @Override
    public boolean handles(DWType type) {
        return type instanceof UnionType;
    }

    @Override
    public String getTypeName() {
        return "UnionType";
    }

    @Override
    public Component make(DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        if (!(dwType instanceof UnionType)) {
            throw new AssertionError();
        }
        List<DWType> of = Arrays.stream(this.unionElements(dwType)).filter(e -> !(e instanceof NullType)).filter(e -> !(e instanceof AnyType)).toList();
        if (of.isEmpty()) {
            return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("Any")).build();
        }
        if (of.size() > 1 && of.stream().anyMatch(e -> e instanceof ReferenceType)) {
            DWType resolvedUnion = this.resolveUnionFromSeq(of, true);
            of = List.of(this.unionElements(resolvedUnion));
        }
        DWType headType = of.get(0);
        boolean heterogeneous = of.stream().anyMatch(a -> !a.getClass().equals(headType.getClass()));
        if (heterogeneous) {
            System.err.println("Error: Not Heterogeneous Union: please check type: " + typeName + " in service: " + this.componentRegistry.getServiceComponent().getName());
            return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("Any")).build();
        }
        boolean isSupportedEnumType = false;
        if (headType instanceof StringType || headType instanceof NumberType) {
            isSupportedEnumType = headType instanceof StringType ? ((StringType)headType).getValue().isPresent() : ((NumberType)headType).getValue().isPresent();
            if (isSupportedEnumType) {
                Map<String, String> enumValues = this.createEnumValues(of);
                Component enumComponent = ((EnumComponent.EnumComponentBuilder)((EnumComponent.EnumComponentBuilder)((EnumComponent.EnumComponentBuilder)EnumComponent.builder().name(outer.getName())).outer(outer.getId())).enumValues(enumValues)).build();
                Component enumType = typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
                enumType = this.componentRegistry.registerComponent(enumType);
                ((EnumComponent)enumComponent).setElementType(enumType.getId());
                return enumComponent;
            }
            return typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
        }
        if (headType instanceof BooleanType) {
            return typeFactory.make(headType, headType.getClass().getSimpleName(), outer);
        }
        DWType resolvedUnion = this.resolveUnionFromSeq(of, false);
        if (resolvedUnion instanceof UnionType) {
            throw new RuntimeException("Error: Not Able to simplify Union: `" + String.valueOf(dwType) + "` please check type: " + typeName + " in service: " + this.componentRegistry.getServiceComponent().getName());
        }
        this.onComponentResolution(resolvedUnion, outer);
        return typeFactory.make(resolvedUnion, typeName, outer);
    }

    private Map<String, String> createEnumValues(List<DWType> options) {
        return options.stream().filter(Objects::nonNull).map(option -> {
            if (option instanceof StringType) {
                return (String)((StringType)option).getValue().get();
            }
            return option.toString();
        }).distinct().collect(Collectors.toMap(item -> item, item -> item));
    }

    private DWType resolveUnionFromSeq(List<DWType> of, boolean resolveRefTypes) {
        TypeHelper helper = new TypeHelper(new ParsingNotificationManager());
        Function<Object, WeaveType> mapper = resolveRefTypes ? a -> (WeaveType)TypeUtils.resolveReferenceType((DWType)((DWType)a)) : a -> (WeaveType)a;
        Seq seq = JavaConverters.collectionAsScalaIterable((Collection)of.stream().map(mapper).collect(Collectors.toList())).toSeq();
        return helper.resolveUnion(helper.unify(seq));
    }

    abstract DWType[] unionElements(DWType var1);

    abstract void onComponentResolution(DWType var1, Component var2);
}

