/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.ExecutableComponentLoader;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.ProviderLoader;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.ServiceModelLoader;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderAdapter;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.Comparator;
import java.util.Map;

public class DefaultServiceModelLoader
implements ServiceModelLoader {
    private final ComponentRegistry componentRegistry;
    private final ProviderLoader providerLoader;
    private final ExecutableComponentLoader executableComponentLoader;

    public DefaultServiceModelLoader(TypeFactory typeFactory, Patch patch) {
        this.componentRegistry = typeFactory.getComponentRegistry();
        this.providerLoader = new ProviderLoader(this.componentRegistry, typeFactory);
        this.executableComponentLoader = new ExecutableComponentLoader(this.componentRegistry, typeFactory, patch);
    }

    @Override
    public ServiceModel loadServiceModel(FlowConnectorModel model) {
        this.loadServiceComponent(model);
        return ServiceModel.builder().components(this.componentRegistry.getComponents().entrySet().stream().sorted(Comparator.comparing(x -> Long.valueOf(((Component)x.getValue()).getId()))).map(Map.Entry::getValue).toList()).build();
    }

    private void loadServiceComponent(FlowConnectorModel flowConnectorModel) {
        Component serviceComponent = ((ServiceComponent.ServiceComponentBuilder)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(flowConnectorModel.getDeveloperName())).description(flowConnectorModel.getDescription())).build();
        this.componentRegistry.registerComponent(serviceComponent);
        this.loadOperations(flowConnectorModel, serviceComponent);
        this.loadValueProviders(flowConnectorModel);
        this.loadTypeProviders(flowConnectorModel);
        this.loadTriggers(flowConnectorModel, serviceComponent);
    }

    private void loadOperations(FlowConnectorModel flowConnectorModel, Component outer) {
        for (OperationModel operation : flowConnectorModel.getOperations()) {
            for (Map.Entry versionedOperation : operation.getVersions().entrySet()) {
                String version = ((Integer)versionedOperation.getKey()).toString();
                OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)versionedOperation.getValue());
                this.executableComponentLoader.load(adaptedOperation, version, outer);
            }
        }
    }

    private void loadValueProviders(FlowConnectorModel flowConnectorModel) {
        for (ValueProviderModel valueProvider : flowConnectorModel.getValueProviders()) {
            this.providerLoader.load(valueProvider);
        }
    }

    private void loadTypeProviders(FlowConnectorModel flowConnectorModel) {
        for (MetadataProviderModel metadataProvider : flowConnectorModel.getMetadataProviders()) {
            this.providerLoader.load(metadataProvider);
        }
    }

    private void loadTriggers(FlowConnectorModel flowConnectorModel, Component outer) {
        for (TriggerModel trigger : flowConnectorModel.getTriggers()) {
            for (Map.Entry versionedTrigger : trigger.getVersions().entrySet()) {
                String version = ((Integer)versionedTrigger.getKey()).toString();
                TriggerModel adaptedTrigger = QueryBuilderAdapter.adapt((TriggerModel)versionedTrigger.getValue());
                this.executableComponentLoader.load(adaptedTrigger, version, outer);
            }
        }
    }
}

