/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.ObjectMetadataValue;
import org.mule.weave.v2.ts.ArrayMetadataValue;

public class MetadataAnnotationMapper {
    public static Map<String, Map<String, Object>> toMap(DWMetadata[] metadata) {
        MetadataAnnotationMapper mapper = new MetadataAnnotationMapper();
        return mapper.toMap(metadata, null);
    }

    private Map<String, Map<String, Object>> toMap(DWMetadata[] metadata, IdentityHashMap identityHashMap) {
        IdentityHashMap identity;
        Map<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        IdentityHashMap identityHashMap2 = identity = identityHashMap != null ? identityHashMap : new IdentityHashMap();
        if (metadata != null && metadata.length > 0) {
            resultMap = this.populateMap(metadata, new HashMap<String, Map<String, Object>>(), identity);
        }
        return resultMap;
    }

    public Map<String, Map<String, Object>> populateMap(DWMetadata[] metadata, Map<String, Map<String, Object>> annotations, IdentityHashMap identityHashMap) {
        if (metadata == null || metadata.length == 0) {
            return null;
        }
        for (DWMetadata meta : metadata) {
            String metaName = meta.getName();
            if (meta.getValue() != null) {
                DWMetadataValue metadataValue = meta.getValue();
                if (identityHashMap.containsKey(metaName)) {
                    return (Map)identityHashMap.get(metaName);
                }
                annotations.put(metaName, new HashMap());
                Object transformedValue = this.transformObject(metadataValue, identityHashMap);
                if (transformedValue != null) {
                    if (transformedValue instanceof Map) {
                        Map valueMap = (Map)transformedValue;
                        annotations.put(metaName, valueMap);
                    } else {
                        HashMap<String, Object> wrapperMap = new HashMap<String, Object>();
                        wrapperMap.put(metaName, transformedValue);
                        annotations.put(metaName, wrapperMap);
                    }
                }
            }
            identityHashMap.put(metaName, annotations);
        }
        return annotations;
    }

    public Object transformObject(DWMetadataValue metadataValue, IdentityHashMap identityHashMap) {
        if (metadataValue == null) {
            return null;
        }
        if (metadataValue instanceof LiteralMetadataValue) {
            LiteralMetadataValue literalMetadataValue = (LiteralMetadataValue)metadataValue;
            return this.transformLiteralMetadata(literalMetadataValue, identityHashMap);
        }
        if (metadataValue instanceof ArrayMetadataValue) {
            ArrayMetadataValue arrayMetadataValue = (ArrayMetadataValue)metadataValue;
            return this.transformArrayMetadata(arrayMetadataValue, identityHashMap);
        }
        if (metadataValue instanceof ObjectMetadataValue) {
            ObjectMetadataValue objectMetadataValue = (ObjectMetadataValue)metadataValue;
            return this.transformObjectMetadata(objectMetadataValue, identityHashMap);
        }
        return null;
    }

    public Object transformLiteralMetadata(LiteralMetadataValue metadataValue, IdentityHashMap identityHashMap) {
        if (metadataValue == null) {
            return null;
        }
        return metadataValue.getValue();
    }

    public List<Object> transformArrayMetadata(ArrayMetadataValue metadataValue, IdentityHashMap identityHashMap) {
        if (metadataValue == null) {
            return new ArrayList<Object>();
        }
        DWMetadataValue[] elements = metadataValue.getElements();
        if (elements == null || elements.length == 0) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> transformedElements = new ArrayList<Object>();
        for (DWMetadataValue element : elements) {
            Object transformedElement = this.transformObject(element, identityHashMap);
            if (transformedElement == null) continue;
            transformedElements.add(transformedElement);
        }
        return transformedElements;
    }

    public Map<String, Object> transformObjectMetadata(ObjectMetadataValue metadataValue, IdentityHashMap identityHashMap) {
        if (metadataValue == null) {
            return new HashMap<String, Object>();
        }
        if (metadataValue.getProperties() == null) {
            return new HashMap<String, Object>();
        }
        KeyValuePairMetadataValue[] properties = metadataValue.getProperties();
        return this.transformPropertiesMetadata(properties, identityHashMap);
    }

    public Map<String, Object> transformPropertiesMetadata(KeyValuePairMetadataValue[] properties, IdentityHashMap identityHashMap) {
        if (properties == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> transformedProperties = new HashMap<String, Object>();
        for (KeyValuePairMetadataValue property : properties) {
            Object transformedValue;
            if (property == null) continue;
            String key = property.getKey();
            DWMetadataValue value = property.getValue();
            if (key == null || value == null || (transformedValue = this.transformObject(value, identityHashMap)) == null) continue;
            transformedProperties.put(key, transformedValue);
        }
        return transformedProperties;
    }
}

