/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.7
import * from com::mulesoft::connectivity::Model

/**
* Annotates variables that should be understood as operation definitions
*/
@AnnotationTarget(targets = ["Variable", "Expression"])
annotation OperationElement()

/**
* Annotates variables that should be understood as connection provider definitions
*/
@AnnotationTarget(targets = ["Variable", "Expression"])
annotation ConnectionElement()

/**
* Annotates variables that should be understood as test connection provider definitions
*/
@AnnotationTarget(targets = ["Variable", "Expression"])
annotation TestConnectionElement()

/**
* Annotates variables that should be understood as trigger definitions
*/
@AnnotationTarget(targets = ["Variable", "Expression"])
annotation TriggerElement()
