/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.8

/**
 * 32bit signed integer.
 *
 * - Expected range of values is from -2147483648 to 2147483647
 * - `Int32` values are valid `Int64` values
 * - `Int32` values are valid `Integer` values
 * - `Int32` values are valid `Double` values
 */
type Int32 = Number <~ { format: "int32" }

/**
 * 64bit signed integer.
 *
 * - Expected range of values is from -9223372036854775808 to 9223372036854775807
 * - `Int32` values are valid `Integer` values
 */
type Int64 = Number <~ { format: "int64" }

/**
 * A signed integer.
 *
 * Has no expected range of values.
 */
type Integer = Number <~ { format: "integer" }

/**
 * IEEE754 binary32 value.
 *
 * - `Float` values are valid `Double` values
 */
type Float = Number <~ { format: "float" }

/**
 * IEEE754 binary64 value.
 */
type Double = Number <~ { format: "double" }

/**
 * String with RFC3339 `full-date` format
 */
type LWDate = String <~ { format: "date" }

/**
 * String with RFC3339 `date-time` format
 */
type LWDateTime = String <~ { format: "date-time" }

type StringArray = Array<String>
type NumberArray = Array<Number>
type BooleanArray = Array<Boolean>
type DateArray = Array<Date>
type DateTimeArray = Array<DateTime>